/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.WSRFConstants;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import de.fzj.unicore.wsrflite.xmlbeans.sg.ServiceGroupRegistration;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.oasisOpen.docs.wsrf.sg2.EntryDocument;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.oasisOpen.docs.wsrf.sg2.ServiceGroupEntryRPDocument;
import org.oasisOpen.docs.wsrf.sg2.ServiceGroupRPDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryClient
extends BaseWSRFClient
implements IRegistryQuery {
    private static final Logger logger = Log.getLogger("unicore.client", RegistryClient.class);
    public static final QName ENTRY_RP = EntryDocument.type.getDocumentElementName();

    public RegistryClient(String url, EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        super(url, address, sec);
    }

    public RegistryClient(EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        super(address, sec);
    }

    public ServiceGroupRPDocument getResourcePropertiesDocument() throws Exception {
        GetResourcePropertyDocumentResponseDocument grprd = GetResourcePropertyDocumentResponseDocument.Factory.parse(this.getResourcePropertyDocument());
        ServiceGroupRPDocument doc = ServiceGroupRPDocument.Factory.parse(grprd.getGetResourcePropertyDocumentResponse().newInputStream());
        return doc;
    }

    public AddResponseDocument addRegistryEntry(AddDocument in) throws Exception {
        ServiceGroupRegistration reg = this.makeProxy(ServiceGroupRegistration.class);
        AddResponseDocument res = reg.Add(in);
        return res;
    }

    public AddResponseDocument addRegistryEntry(EndpointReferenceType memberEpr, ContentType content) throws Exception {
        AddDocument in = AddDocument.Factory.newInstance();
        in.addNewAdd().setContent(content);
        in.getAdd().setMemberEPR(memberEpr);
        return this.addRegistryEntry(in);
    }

    public AddResponseDocument addRegistryEntry(EndpointReferenceType memberEpr) throws Exception {
        ContentType content = ContentType.Factory.newInstance();
        content.setNil();
        return this.addRegistryEntry(memberEpr, content);
    }

    public static ContentType makeContent(XmlObject[] os) {
        ContentType content = ContentType.Factory.newInstance();
        XmlCursor c = content.addNewRPDoc().newCursor();
        c.toNextToken();
        for (XmlObject o : os) {
            XmlCursor c1 = o.newCursor();
            c1.toNextToken();
            c1.copyXml(c);
            c1.dispose();
        }
        return content;
    }

    public static ContentType makeContent(List<XmlObject> os) {
        return RegistryClient.makeContent(os.toArray(new XmlObject[os.size()]));
    }

    @Override
    public List<EndpointReferenceType> listServices(QName porttype) throws Exception {
        return this.listServices(porttype, null);
    }

    @Override
    public List<EndpointReferenceType> listServices(QName porttype, IRegistryQuery.ServiceListFilter acceptFilter) throws Exception {
        QName child = new QName(ServiceGroupEntryRPDocument.type.getDocumentElementName().getNamespaceURI(), "MemberServiceEPR");
        String xpath = "declare namespace sg='" + ServiceGroupEntryRPDocument.type.getDocumentElementName().getNamespaceURI() + "' ; \n" + "declare namespace add='" + WSRFConstants.EPR_METADATA.getNamespaceURI() + "';\n" + "declare namespace meta='" + WSRFConstants.INTERFACE_NAME.getNamespaceURI() + "';\n" + ".//sg:ServiceGroupRP/sg:Entry" + "/sg:MemberServiceEPR/add:" + WSRFConstants.EPR_METADATA.getLocalPart() + "/meta:" + WSRFConstants.INTERFACE_NAME.getLocalPart() + "[matches(.,'" + porttype.getLocalPart() + "[ .*]?$')]" + "/ancestor::sg:Entry";
        QueryResourcePropertiesResponseDocument.QueryResourcePropertiesResponse res = this.queryResourceProperties(xpath).getQueryResourcePropertiesResponse();
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        try {
            for (XmlObject o : WSUtilities.extractAllMatchingElements(res, child)) {
                EntryType entry = EntryType.Factory.parse(o.newInputStream());
                result.add(entry.getMemberServiceEPR());
            }
        }
        catch (Exception e) {
            Log.logException("Registry content parse error.", e, logger);
        }
        return result;
    }

    @Override
    public List<EndpointReferenceType> listAccessibleServices(QName porttype) throws Exception {
        return this.listServices(porttype, new PingWSRFServicesFilter());
    }

    @Override
    public List<EntryType> listEntries() throws Exception {
        EntryType[] entries = this.getResourcePropertiesDocument().getServiceGroupRP().getEntryArray();
        return Arrays.asList(entries);
    }

    public class PingWSRFServicesFilter
    implements IRegistryQuery.ServiceListFilter {
        @Override
        public boolean accept(EntryType entry) {
            try {
                IClientConfiguration sp = RegistryClient.this.getSecurityConfiguration();
                BaseWSRFClient c = new BaseWSRFClient(entry.getMemberServiceEPR().getAddress().getStringValue(), entry.getMemberServiceEPR(), sp);
                c.getCurrentTime();
                return true;
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("", e);
                }
                return false;
            }
        }
    }
}

