/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

public class LuceneIndexHolder {
    private volatile long lastCacheInvalidation = System.currentTimeMillis();
    private IndexSearcher indexSearcher;
    private IndexReader indexReader;
    private int count = 0;
    private boolean markForClose = false;
    private String subIndex;

    public LuceneIndexHolder(String subIndex, Directory dir) throws IOException {
        this.indexReader = IndexReader.open(dir);
        this.indexSearcher = new IndexSearcher(this.indexReader);
        this.subIndex = subIndex;
    }

    public LuceneIndexHolder(String subIndex, IndexSearcher indexSearcher) {
        this.subIndex = subIndex;
        this.indexSearcher = indexSearcher;
        this.indexReader = indexSearcher.getIndexReader();
    }

    public void refresh(IndexReader indexReader) {
        try {
            this.indexSearcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.indexReader = indexReader;
        this.indexSearcher = new IndexSearcher(indexReader);
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public synchronized void acquire() {
        ++this.count;
    }

    public synchronized void release() {
        --this.count;
        this.checkIfCanClose();
    }

    public synchronized void markForClose() {
        this.markForClose = true;
        this.checkIfCanClose();
    }

    private void checkIfCanClose() {
        if (this.markForClose && this.count <= 0) {
            try {
                this.indexSearcher.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.indexReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getLastCacheInvalidation() {
        return this.lastCacheInvalidation;
    }

    public void setLastCacheInvalidation(long lastCacheInvalidation) {
        this.lastCacheInvalidation = lastCacheInvalidation;
    }
}

