/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.pattern;

import java.util.LinkedList;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenHandler;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.FilterExpr;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.AnyNodeTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.LocationPathPattern;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NameTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NamespaceTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NodeTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NodeTypeTest;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.Pattern;

public class PatternHandler
extends JaxenHandler {
    private Pattern pattern;

    public Pattern getPattern() {
        return this.getPattern(true);
    }

    public Pattern getPattern(boolean shouldSimplify) {
        if (shouldSimplify && !this.simplified) {
            this.pattern.simplify();
            this.simplified = true;
        }
        return this.pattern;
    }

    @Override
    public void endXPath() throws JaxenException {
        this.pattern = (Pattern)this.pop();
        System.out.println("stack is: " + this.stack);
        this.popFrame();
    }

    @Override
    public void endPathExpr() throws JaxenException {
        LinkedList frame = this.popFrame();
        System.out.println("endPathExpr(): " + frame);
        this.push(frame.removeFirst());
    }

    @Override
    public void startAbsoluteLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.createAbsoluteLocationPath());
    }

    @Override
    public void endAbsoluteLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    @Override
    public void startRelativeLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.createRelativeLocationPath());
    }

    @Override
    public void endRelativeLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    @Override
    protected void endLocationPath() throws JaxenException {
        LinkedList list = this.popFrame();
        System.out.println("endLocationPath: " + list);
        LocationPathPattern locationPath = (LocationPathPattern)list.removeFirst();
        this.push(locationPath);
        boolean doneNodeTest = false;
        while (!list.isEmpty()) {
            LocationPathPattern parent;
            Object filter = list.removeFirst();
            if (filter instanceof NodeTest) {
                if (doneNodeTest) {
                    parent = new LocationPathPattern((NodeTest)filter);
                    locationPath.setParentPattern(parent);
                    locationPath = parent;
                    doneNodeTest = false;
                    continue;
                }
                locationPath.setNodeTest((NodeTest)filter);
                continue;
            }
            if (filter instanceof FilterExpr) {
                locationPath.addFilter((FilterExpr)filter);
                continue;
            }
            if (!(filter instanceof LocationPathPattern)) continue;
            parent = (LocationPathPattern)filter;
            locationPath.setParentPattern(parent);
            locationPath = parent;
            doneNodeTest = false;
        }
    }

    @Override
    public void startNameStep(int axis, String prefix, String localName) throws JaxenException {
        this.pushFrame();
        short nodeType = 1;
        switch (axis) {
            case 9: {
                nodeType = 2;
                break;
            }
            case 10: {
                nodeType = 13;
            }
        }
        if (prefix != null && prefix.length() > 0 && !prefix.equals("*")) {
            this.push(new NamespaceTest(prefix, nodeType));
        }
        if (localName != null && localName.length() > 0 && !localName.equals("*")) {
            this.push(new NameTest(localName, nodeType));
        }
    }

    @Override
    public void startTextNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(new NodeTypeTest(3));
    }

    @Override
    public void startCommentNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(new NodeTypeTest(8));
    }

    @Override
    public void startAllNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(AnyNodeTest.getInstance());
    }

    @Override
    public void startProcessingInstructionNodeStep(int axis, String name) throws JaxenException {
        this.pushFrame();
        this.push(new NodeTypeTest(7));
    }

    @Override
    protected void endStep() {
        LinkedList list = this.popFrame();
        if (!list.isEmpty()) {
            this.push(list.removeFirst());
            if (!list.isEmpty()) {
                System.out.println("List should now be empty!" + list);
            }
        }
    }

    @Override
    public void startUnionExpr() throws JaxenException {
    }

    @Override
    public void endUnionExpr(boolean create) throws JaxenException {
        if (create) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createUnionExpr(lhs, rhs));
        }
    }

    protected Pattern createAbsoluteLocationPath() {
        return new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
    }

    protected Pattern createRelativeLocationPath() {
        return new LocationPathPattern();
    }
}

