/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Counter
implements Writable {
    private String name;
    private String displayName;
    private long value = 0L;

    protected Counter() {
    }

    protected Counter(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    @Deprecated
    protected synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.name = Text.readString(in);
        this.displayName = in.readBoolean() ? Text.readString(in) : this.name;
        this.value = WritableUtils.readVLong(in);
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString(out, this.name);
        boolean distinctDisplayName = !this.name.equals(this.displayName);
        out.writeBoolean(distinctDisplayName);
        if (distinctDisplayName) {
            Text.writeString(out, this.displayName);
        }
        WritableUtils.writeVLong(out, this.value);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    public synchronized long getValue() {
        return this.value;
    }

    public synchronized void setValue(long value) {
        this.value = value;
    }

    public synchronized void increment(long incr) {
        this.value += incr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof Counter) {
            Object object = genericRight;
            synchronized (object) {
                Counter right = (Counter)genericRight;
                return this.name.equals(right.name) && this.displayName.equals(right.displayName) && this.value == right.value;
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.name.hashCode() + this.displayName.hashCode();
    }
}

