/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime.extensions;

import com.ibm.xtq.xslt.runtime.extensions.ExsltBase;
import com.ibm.xtq.xslt.runtime.extensions.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExsltMath
extends ExsltBase {
    private static final String PI = "3.1415926535897932384626433832795028841971693993751";
    private static final String E = "2.71828182845904523536028747135266249775724709369996";
    private static final String SQRRT2 = "1.41421356237309504880168872420969807856967187537694";
    private static final String LN2 = "0.69314718055994530941723212145817656807550013436025";
    private static final String LN10 = "2.302585092994046";
    private static final String LOG2E = "1.4426950408889633";
    private static final String SQRT1_2 = "0.7071067811865476";

    public static double max(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() == 0) {
            return Double.NaN;
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            double d2 = ExsltMath.toNumber(node);
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double min(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() == 0) {
            return Double.NaN;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            double d2 = ExsltMath.toNumber(node);
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static NodeList highest(NodeList nodeList) {
        double d = ExsltMath.max(nodeList);
        NodeSet nodeSet = new NodeSet();
        if (Double.isNaN(d)) {
            return nodeSet;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            double d2 = ExsltMath.toNumber(node);
            if (d2 != d) continue;
            nodeSet.addItem(node);
        }
        return nodeSet;
    }

    public static NodeList lowest(NodeList nodeList) {
        double d = ExsltMath.min(nodeList);
        NodeSet nodeSet = new NodeSet();
        if (Double.isNaN(d)) {
            return nodeSet;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            double d2 = ExsltMath.toNumber(node);
            if (d2 != d) continue;
            nodeSet.addItem(node);
        }
        return nodeSet;
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double acos(double d) {
        return Math.acos(d);
    }

    public static double asin(double d) {
        return Math.asin(d);
    }

    public static double atan(double d) {
        return Math.atan(d);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double exp(double d) {
        return Math.exp(d);
    }

    public static double log(double d) {
        return Math.log(d);
    }

    public static double power(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static double random() {
        return Math.random();
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double constant(String string, double d) {
        String string2 = null;
        if (string.equals("PI")) {
            string2 = PI;
        } else if (string.equals("E")) {
            string2 = E;
        } else if (string.equals("SQRRT2")) {
            string2 = SQRRT2;
        } else if (string.equals("LN2")) {
            string2 = LN2;
        } else if (string.equals("LN10")) {
            string2 = LN10;
        } else if (string.equals("LOG2E")) {
            string2 = LOG2E;
        } else if (string.equals("SQRT1_2")) {
            string2 = SQRT1_2;
        }
        if (string2 != null) {
            int n = new Double(d).intValue();
            if (n <= string2.length()) {
                string2 = string2.substring(0, n);
            }
            return new Double(string2);
        }
        return Double.NaN;
    }
}

