/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.types.ByteType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IPrimitiveType;
import com.ibm.xylem.types.IntType;
import java.util.LinkedList;

public class HexEscapeInstruction
extends UnaryPrimopInstruction {
    public HexEscapeInstruction() {
    }

    public HexEscapeInstruction(Instruction instruction) {
        super(instruction);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new HexEscapeInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (type.equals(IntType.s_intType, typeEnvironment)) {
            typeEnvironment.unify(type, IntType.s_intType, this);
        } else if (type.equals(ByteType.s_byteType, typeEnvironment)) {
            typeEnvironment.unify(type, ByteType.s_byteType, this);
        } else {
            typeEnvironment.unify(type, CharType.s_charType, this);
        }
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        this.m_operand.getType(typeEnvironment, bindingEnvironment);
        return CharType.s_charType.getStreamType();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this.m_operand);
        if (type instanceof INumericalType) {
            if (type instanceof ByteType) {
                dataFlowCodeGenerationHelper.appendAssignment(string3, CharType.s_charType.getStreamType(), "Integer.toString(" + string2 + "&0xFF, 16).toUpperCase().toCharArray()", codeGenerationTracker);
            } else if (type instanceof IPrimitiveType) {
                dataFlowCodeGenerationHelper.appendAssignment(string3, CharType.s_charType.getStreamType(), "Integer.toString(" + string2 + ", 16).toUpperCase().toCharArray()", codeGenerationTracker);
            } else {
                dataFlowCodeGenerationHelper.appendAssignment(string3, CharType.s_charType.getStreamType(), "Integer.toString(((Number) " + string2 + ").intValue(), 16).toUpperCase().toCharArray()", codeGenerationTracker);
            }
        } else {
            throw new UnsupportedOperationException("Hex-Escape not supported for type " + type);
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        Type type = codeGenerationTracker.resolveType(this.m_operand);
        if (!(type instanceof INumericalType)) throw new UnsupportedOperationException("Hex-Escape not supported for type " + type);
        if (type instanceof ByteType) {
            instructionListBuilder.appendConstant(255);
            instructionListBuilder.appendIAnd();
            instructionListBuilder.appendConstant(16);
            instructionListBuilder.appendInvokeStatic("java.lang.Integer", "toString", (com.ibm.xtq.bcel.generic.Type)BasicType.STRING, new BasicType[]{BasicType.INT, BasicType.INT});
            instructionListBuilder.appendInvokeMethod("java.lang.String", "toUpperCase", BasicType.STRING);
            instructionListBuilder.appendInvokeMethod("java.lang.String", "toCharArray", BCELCodeGenerationHelper.s_charArrayType);
            return;
        } else {
            if (!(type instanceof IPrimitiveType)) throw new UnsupportedOperationException("Hex-Escape not supported for type " + type);
            instructionListBuilder.appendConstant(16);
            instructionListBuilder.appendInvokeStatic("java.lang.Integer", "toString", (com.ibm.xtq.bcel.generic.Type)BasicType.STRING, new BasicType[]{BasicType.INT, BasicType.INT});
            instructionListBuilder.appendInvokeMethod("java.lang.String", "toUpperCase", BasicType.STRING);
            instructionListBuilder.appendInvokeMethod("java.lang.String", "toCharArray", BCELCodeGenerationHelper.s_charArrayType);
        }
    }

    @Override
    public String innerToString() {
        return "hex-escape";
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)) instanceof Byte) {
            byte by = (Byte)object;
            StringStream stringStream = new StringStream(Integer.toString(by & 0xFF, 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, stringStream);
        }
        if (object instanceof Number) {
            StringStream stringStream = new StringStream(Integer.toString(((Number)object).intValue(), 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, stringStream);
        }
        if (object instanceof Character) {
            StringStream stringStream = new StringStream(Integer.toString(((Character)object).charValue(), 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, stringStream);
        }
        throw new UnsupportedOperationException("Hex-Escape is not supported on type " + object.getClass() + " with value:" + object);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new HexEscapeInstruction(instruction);
    }
}

