/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.instructions;

import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.interpreter.CursorStream;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class EqualityInstruction
extends BinaryPrimopInstruction {
    protected boolean m_testInequality;

    public EqualityInstruction() {
    }

    @Override
    public com.ibm.xylem.Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public com.ibm.xylem.Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new EqualityInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_testInequality);
    }

    public EqualityInstruction(Instruction instruction, Instruction instruction2, boolean bl) {
        super(instruction, instruction2);
        this.m_testInequality = bl;
    }

    public boolean isTestingInequality() {
        return this.m_testInequality;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        com.ibm.xylem.Type type = codeGenerationTracker.resolveType(this.m_operand1);
        com.ibm.xylem.Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        if (type instanceof BooleanType && type2 instanceof BooleanType) {
            codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
            codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
            SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
            switchBuilder.startTestIEquals();
            if (this.m_testInequality) {
                instructionListBuilder.appendConstant(false);
            } else {
                instructionListBuilder.appendConstant(true);
            }
            switchBuilder.endTest();
            switchBuilder.startElse();
            if (this.m_testInequality) {
                instructionListBuilder.appendConstant(true);
            } else {
                instructionListBuilder.appendConstant(false);
            }
            switchBuilder.endElse();
        } else if (type instanceof INumericalType && type2 instanceof INumericalType) {
            if (type.equals(type2)) {
                codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
                codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
                ((INumericalType)((Object)type)).generateCodeForOperation(instructionListBuilder, 9);
            } else if (type instanceof IntType && type2 instanceof DoubleType) {
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
                codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
                DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, 9);
            } else if (type2 instanceof IntType && type instanceof DoubleType) {
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
                codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
                DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, 9);
            } else {
                throw new UnsupportedOperationException(type + " and " + type2);
            }
            if (this.m_testInequality) {
                NotInstruction.generateNot(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            }
        } else if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CharStreamToJavaStringInstruction.generateJavaString(bCELCodeGenerationHelper, codeGenerationTracker, this.m_operand2, instructionListBuilder);
            instructionListBuilder.appendConstant(this.m_testInequality ? 1 : 0);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.STRING, BasicType.INT});
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CharType.s_charType.getStreamType())) {
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CharStreamToJavaStringInstruction.generateJavaString(bCELCodeGenerationHelper, codeGenerationTracker, this.m_operand1, instructionListBuilder);
            instructionListBuilder.appendConstant(this.m_testInequality ? 1 : 0);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.STRING, BasicType.INT});
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(this.m_testInequality ? 1 : 0);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.DOUBLE, BasicType.INT});
        } else if (type2.equals(CursorType.s_cursorType) && type instanceof INumericalType) {
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(this.m_testInequality ? 1 : 0);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.DOUBLE, BasicType.INT});
        } else if (type2.equals(CharType.s_charType.getStreamType()) && type.equals(CharType.s_charType.getStreamType())) {
            codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
            codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
            ArrayType arrayType = BCELCodeGenerationHelper.s_charArrayType;
            instructionListBuilder.appendInvokeStatic("java.util.Arrays", "equals", (Type)BasicType.BOOLEAN, new ArrayType[]{arrayType, arrayType});
            if (this.m_testInequality) {
                NotInstruction.generateNot(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            }
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(this.m_testInequality ? 1 : 0);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, CursorType.s_bcelType, BasicType.INT});
        } else if (type.equals(BooleanType.s_booleanType)) {
            codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, BooleanType.s_booleanType, codeGenerationTracker, instructionListBuilder);
            SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
            if (this.m_testInequality) {
                switchBuilder.startTestINotEquals();
            } else {
                switchBuilder.startTestIEquals();
            }
            instructionListBuilder.appendConstant(1);
            switchBuilder.endTest();
            switchBuilder.startElse();
            instructionListBuilder.appendConstant(0);
            switchBuilder.endElse();
        } else if (type2.equals(BooleanType.s_booleanType)) {
            codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, BooleanType.s_booleanType, codeGenerationTracker, instructionListBuilder);
            SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
            if (this.m_testInequality) {
                switchBuilder.startTestINotEquals();
            } else {
                switchBuilder.startTestIEquals();
            }
            instructionListBuilder.appendConstant(1);
            switchBuilder.endTest();
            switchBuilder.startElse();
            instructionListBuilder.appendConstant(0);
            switchBuilder.endElse();
        } else if (type instanceof INumericalType || type2 instanceof INumericalType) {
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, 9);
            if (this.m_testInequality) {
                NotInstruction.generateNot(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            }
        } else {
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, CharType.s_charType.getStreamType(), codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, CharType.s_charType.getStreamType(), codeGenerationTracker, instructionListBuilder);
            ArrayType arrayType = BCELCodeGenerationHelper.s_charArrayType;
            instructionListBuilder.appendInvokeStatic("java.util.Arrays", "equals", (Type)BasicType.BOOLEAN, new ArrayType[]{arrayType, arrayType});
            if (this.m_testInequality) {
                NotInstruction.generateNot(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            }
        }
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        com.ibm.xylem.Type type = codeGenerationTracker.resolveType(this.m_operand1);
        com.ibm.xylem.Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        if (type instanceof INumericalType && type2 instanceof INumericalType || type instanceof BooleanType && type2 instanceof BooleanType) {
            String string3 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string4 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string3 + (this.m_testInequality ? " != " : " == ") + string4, codeGenerationTracker);
        } else if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            String string5 = CursorType.generateStartOneTimeUse(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string6 = CharStreamToJavaStringInstruction.generateJavaString(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_operand2, null);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string5 + ", " + string6 + ", " + (this.m_testInequality ? 1 : 0) + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string5, this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CharType.s_charType.getStreamType())) {
            String string7 = CharStreamToJavaStringInstruction.generateJavaString(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_operand1, null);
            String string8 = CursorType.generateStartOneTimeUse(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string8 + ", " + string7 + ", " + (this.m_testInequality ? 1 : 0) + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string8, this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            String string9 = CursorType.generateStartOneTimeUse(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string10 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string9 + ", (double) " + string10 + ", " + (this.m_testInequality ? 1 : 0) + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string9, this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type instanceof INumericalType) {
            String string11 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string12 = CursorType.generateStartOneTimeUse(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string12 + ", (double) " + string11 + ", " + (this.m_testInequality ? 1 : 0) + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string12, this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CharType.s_charType.getStreamType()) && type.equals(CharType.s_charType.getStreamType())) {
            String string13 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string14 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), (this.m_testInequality ? "!" : "") + Arrays.class.getName() + ".equals(" + string13 + ", " + string14 + ")", codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            String string15 = CursorType.generateWithCloneIfNeeded(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string16 = CursorType.generateWithCloneIfNeeded(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string15 + ", " + string16 + ", " + (this.m_testInequality ? 1 : 0) + ")", codeGenerationTracker);
        } else if (type.equals(BooleanType.s_booleanType)) {
            String string17 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string18 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, BooleanType.s_booleanType, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string17 + (this.m_testInequality ? " != " : " == ") + string18, codeGenerationTracker);
        } else if (type2.equals(BooleanType.s_booleanType)) {
            String string19 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            String string20 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, BooleanType.s_booleanType, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string20 + (this.m_testInequality ? " != " : " == ") + string19, codeGenerationTracker);
        } else if (type instanceof INumericalType) {
            String string21 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string22 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string21 + (this.m_testInequality ? " != " : " == ") + string22, codeGenerationTracker);
        } else if (type2 instanceof INumericalType) {
            String string23 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            String string24 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string24 + (this.m_testInequality ? " != " : " == ") + string23, codeGenerationTracker);
        } else {
            String string25 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, CharType.s_charType.getStreamType(), codeGenerationTracker);
            String string26 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, CharType.s_charType.getStreamType(), codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), (this.m_testInequality ? "!" : "") + Arrays.class.getName() + ".equals(" + string25 + ", " + string26 + ")", codeGenerationTracker);
        }
        return string2;
    }

    @Override
    public String innerToString() {
        return this.m_testInequality ? "unequal?" : "equal?";
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        com.ibm.xylem.Type type = this.m_operand1.evaluateType(function);
        com.ibm.xylem.Type type2 = this.m_operand2.evaluateType(function);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        if (type instanceof INumericalType && type2 instanceof INumericalType || type instanceof BooleanType && type2 instanceof BooleanType) {
            object2 = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
            object = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        } else if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = ((Object)((IStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
        } else if (type.equals(CharType.s_charType.getStreamType()) && type2.equals(CursorType.s_cursorType)) {
            object = ((Object)((IStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
            object2 = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
        } else if (type instanceof INumericalType && type2.equals(CursorType.s_cursorType)) {
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object2 = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
        } else if (type2.equals(CharType.s_charType.getStreamType()) && type.equals(CharType.s_charType.getStreamType())) {
            object2 = ((Object)((IStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
            object = ((Object)((IStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
        } else if (type.equals(BooleanType.s_booleanType)) {
            object2 = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, BooleanType.s_booleanType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
        } else if (type2.equals(BooleanType.s_booleanType)) {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, BooleanType.s_booleanType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        } else if (type instanceof INumericalType) {
            object2 = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
        } else if (type2 instanceof INumericalType) {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        } else {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, CharType.s_charType.getStreamType(), function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object2 = ((Object)((IStream)object2)).toString();
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, CharType.s_charType.getStreamType(), function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object = ((Object)((IStream)object)).toString();
        }
        boolean bl2 = BasisLibrary.compare(object2, object, this.m_testInequality ? 1 : 0);
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, bl3);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new EqualityInstruction(instruction, instruction2, this.m_testInequality);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        EqualityInstruction equalityInstruction = (EqualityInstruction)object;
        return this.m_testInequality == equalityInstruction.m_testInequality;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeBoolean(this.m_testInequality);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_testInequality = readObjectFileHelper.readBoolean();
    }
}

