/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen.bcel;

import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.GOTO;
import com.ibm.xtq.bcel.generic.IFEQ;
import com.ibm.xtq.bcel.generic.IFNE;
import com.ibm.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xtq.bcel.generic.PUSH;
import com.ibm.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SwitchBuilder {
    public InstructionList m_il;
    public ClassGenerationHelper m_cgh;
    protected BranchInstruction m_bi;
    protected InstructionHandle m_else;
    protected BranchInstruction m_elseSkip;
    protected InstructionHandle m_switchInsertionPoint;
    protected ArrayList m_elseSkips;
    protected ArrayList m_testsAndLabels;
    protected int m_testIndex = 0;

    public SwitchBuilder(InstructionListBuilder instructionListBuilder, int n) {
        this(instructionListBuilder.getInstructionList(), instructionListBuilder.getClassGenerationHelper(), n);
    }

    public SwitchBuilder(InstructionList instructionList, ClassGenerationHelper classGenerationHelper, int n) {
        this.m_il = instructionList;
        this.m_cgh = classGenerationHelper;
        if (n == 1) {
            this.m_bi = null;
        } else {
            this.m_elseSkips = new ArrayList();
            this.m_testsAndLabels = new ArrayList();
            this.m_switchInsertionPoint = this.m_il.append(new TABLESWITCH(new int[0], new InstructionHandle[0], null));
        }
    }

    public void startTestIEquals() {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = new IF_ICMPNE(null);
        this.m_il.append(this.m_bi);
    }

    public void startTestINotEquals() {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = new IF_ICMPEQ(null);
        this.m_il.append(this.m_bi);
    }

    public void startTest(short s) {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = InstructionFactory.createBranchInstruction(s, null);
        this.m_il.append(this.m_bi);
    }

    public void startTestAEquals() {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = new IF_ACMPNE(null);
        this.m_il.append(this.m_bi);
    }

    public void startTestTrue() {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = new IFEQ(null);
        this.m_il.append(this.m_bi);
    }

    public void startTestFalse() {
        if (this.m_testsAndLabels != null) {
            throw new UnsupportedOperationException();
        }
        this.m_bi = new IFNE(null);
        this.m_il.append(this.m_bi);
    }

    public void startTest(Object object) {
        if (object instanceof Number) {
            this.startTest(((Number)object).intValue());
        } else if (object instanceof Character) {
            this.startTest(((Character)object).charValue());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void startTest(int n) {
        if (this.m_testsAndLabels == null) {
            this.m_il.append(new PUSH(this.m_cgh.m_cpg, n));
            this.m_bi = new IF_ICMPNE(null);
            this.m_il.append(this.m_bi);
        } else {
            this.m_testsAndLabels.add(new Object[]{new Integer(n), this.m_il.append(InstructionConstants.NOP)});
        }
    }

    public void endTest() {
        if (this.m_testsAndLabels == null) {
            this.m_elseSkip = new GOTO(null);
            this.m_il.append(this.m_elseSkip);
        } else {
            GOTO gOTO = new GOTO(null);
            this.m_elseSkips.add(gOTO);
            this.m_il.append(gOTO);
        }
        ++this.m_testIndex;
    }

    public void startElse() {
        this.m_else = this.m_il.append(InstructionConstants.NOP);
    }

    public void endElse() {
        Object object;
        if (this.m_bi == null) {
            object = new int[this.m_testIndex];
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.m_testIndex];
            Collections.sort(this.m_testsAndLabels, new Comparator(){

                public int compare(Object object, Object object2) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    return ((Integer)objectArray[0]).compareTo((Integer)objectArray2[0]);
                }
            });
            for (int i = 0; i < this.m_testIndex; ++i) {
                Object[] objectArray = (Object[])this.m_testsAndLabels.get(i);
                object[i] = (Integer)objectArray[0];
            }
            LOOKUPSWITCH lOOKUPSWITCH = new LOOKUPSWITCH((int[])object, instructionHandleArray, null);
            this.m_bi = lOOKUPSWITCH;
            for (int i = 0; i < this.m_testIndex; ++i) {
                Object[] objectArray = (Object[])this.m_testsAndLabels.get(i);
                lOOKUPSWITCH.setTarget(i, (InstructionHandle)objectArray[1]);
            }
            this.m_switchInsertionPoint.setInstruction(this.m_bi);
        }
        this.m_bi.setTarget(this.m_else);
        object = this.m_il.append(InstructionConstants.NOP);
        if (this.m_testsAndLabels == null) {
            if (this.m_elseSkip != null) {
                this.m_elseSkip.setTarget((InstructionHandle)object);
            }
        } else {
            for (int i = 0; i < this.m_testIndex; ++i) {
                ((BranchInstruction)this.m_elseSkips.get(i)).setTarget((InstructionHandle)object);
            }
        }
    }
}

