/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class LibraryTupleTranslator
extends AbstractTupleTranslator<Library> {
    private static final int LIBRARY_PAYLOAD_TUPLE_FIELD_INDEX = 2;

    protected LibraryTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.LIBRARY_DATASET, 2);
    }

    @Override
    protected Library createMetadataEntityFromARecord(ARecord libraryRecord) {
        String dataverseCanonicalName = ((AString)libraryRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String libraryName = ((AString)libraryRecord.getValueByPos(1)).getStringValue();
        ARecordType libraryRecordType = libraryRecord.getType();
        int pendingOpIdx = libraryRecordType.getFieldIndex("PendingOp");
        int pendingOp = pendingOpIdx >= 0 ? ((AInt32)libraryRecord.getValueByPos(pendingOpIdx)).getIntegerValue() : 0;
        int languageIdx = libraryRecordType.getFieldIndex("Language");
        String language = languageIdx >= 0 ? ((AString)libraryRecord.getValueByPos(languageIdx)).getStringValue() : ExternalFunctionLanguage.JAVA.name();
        return new Library(dataverseName, libraryName, language, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Library library) throws HyracksDataException {
        String dataverseCanonicalName = library.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(library.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.LIBRARY_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(library.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.writeOpenFields(library);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Library library) throws HyracksDataException {
        this.writeLanguage(library);
        this.writePendingOp(library);
    }

    private void writeLanguage(Library library) throws HyracksDataException {
        String language = library.getLanguage();
        this.fieldName.reset();
        this.aString.setValue("Language");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(language);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writePendingOp(Library library) throws HyracksDataException {
        int pendingOp = library.getPendingOp();
        if (pendingOp != 0) {
            this.fieldName.reset();
            this.aString.setValue("PendingOp");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.int32Serde.serialize((Object)new AInt32(pendingOp), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }
}

