/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.api.IResourceFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.accessors.ShortBinaryComparatorFactory;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexLocalResourceFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public class InvertedIndexResourceFactoryProvider
implements IResourceFactoryProvider {
    public static final InvertedIndexResourceFactoryProvider INSTANCE = new InvertedIndexResourceFactoryProvider();

    private InvertedIndexResourceFactoryProvider() {
    }

    @Override
    public IResourceFactory getResourceFactory(MetadataProvider mdProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories) throws AlgebricksException {
        List<List<String>> primaryKeys = dataset.getPrimaryKeys();
        List<List<String>> secondaryKeys = index.getKeyFieldNames();
        List<String> filterFieldName = DatasetUtil.getFilterField(dataset);
        int numPrimaryKeys = primaryKeys.size();
        int numSecondaryKeys = secondaryKeys.size();
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            throw new CompilationException(1016, new Serializable[]{index.getIndexType().name(), dataset.getDatasetType()});
        }
        if (numPrimaryKeys > 1) {
            throw new AsterixException("Cannot create inverted index on dataset with composite primary key.");
        }
        if (numSecondaryKeys > 1) {
            throw new AsterixException("Cannot create composite inverted index on multiple fields.");
        }
        boolean isPartitioned = index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || index.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numTokenKeyPairFields = !isPartitioned ? 1 + numPrimaryKeys : 2 + numPrimaryKeys;
        int[] invertedIndexFields = null;
        int[] secondaryFilterFieldsForNonBulkLoadOps = null;
        int[] invertedIndexFieldsForNonBulkLoadOps = null;
        int[] secondaryFilterFields = null;
        if (filterFieldName != null) {
            int i;
            invertedIndexFields = new int[numTokenKeyPairFields];
            for (i = 0; i < invertedIndexFields.length; ++i) {
                invertedIndexFields[i] = i;
            }
            secondaryFilterFieldsForNonBulkLoadOps = new int[filterFieldName.size()];
            secondaryFilterFieldsForNonBulkLoadOps[0] = numSecondaryKeys + numPrimaryKeys;
            invertedIndexFieldsForNonBulkLoadOps = new int[numSecondaryKeys + numPrimaryKeys];
            for (i = 0; i < invertedIndexFieldsForNonBulkLoadOps.length; ++i) {
                invertedIndexFieldsForNonBulkLoadOps[i] = i;
            }
            secondaryFilterFields = new int[filterFieldName.size()];
            secondaryFilterFields[0] = numTokenKeyPairFields - numPrimaryKeys + numPrimaryKeys;
        }
        IStorageComponentProvider storageComponentProvider = mdProvider.getStorageComponentProvider();
        IStorageManager storageManager = storageComponentProvider.getStorageManager();
        ILSMOperationTrackerFactory opTrackerFactory = dataset.getIndexOperationTrackerFactory(index);
        ILSMIOOperationCallbackFactory ioOpCallbackFactory = dataset.getIoOperationCallbackFactory(index);
        ILSMPageWriteCallbackFactory pageWriteCallbackFactory = dataset.getPageWriteCallbackFactory();
        IMetadataPageManagerFactory metadataPageManagerFactory = storageComponentProvider.getMetadataPageManagerFactory();
        AsterixVirtualBufferCacheProvider vbcProvider = new AsterixVirtualBufferCacheProvider(dataset.getDatasetId());
        ILSMIOOperationSchedulerProvider ioSchedulerProvider = storageComponentProvider.getIoOperationSchedulerProvider();
        double bloomFilterFalsePositiveRate = mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate();
        ITypeTraits[] typeTraits = InvertedIndexResourceFactoryProvider.getInvListTypeTraits(mdProvider, dataset, recordType, metaType);
        IBinaryComparatorFactory[] cmpFactories = InvertedIndexResourceFactoryProvider.getInvListComparatorFactories(mdProvider, dataset, recordType, metaType);
        ITypeTraits[] tokenTypeTraits = InvertedIndexResourceFactoryProvider.getTokenTypeTraits(dataset, index, recordType, metaType);
        IBinaryComparatorFactory[] tokenCmpFactories = InvertedIndexResourceFactoryProvider.getTokenComparatorFactories(dataset, index, recordType, metaType);
        IBinaryTokenizerFactory tokenizerFactory = InvertedIndexResourceFactoryProvider.getTokenizerFactory(dataset, index, recordType, metaType);
        return new LSMInvertedIndexLocalResourceFactory(storageManager, typeTraits, cmpFactories, filterTypeTraits, filterCmpFactories, secondaryFilterFields, opTrackerFactory, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, (IVirtualBufferCacheProvider)vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, true, tokenTypeTraits, tokenCmpFactories, tokenizerFactory, isPartitioned, invertedIndexFields, secondaryFilterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, bloomFilterFalsePositiveRate);
    }

    private static ITypeTraits[] getInvListTypeTraits(MetadataProvider metadataProvider, Dataset dataset, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        ITypeTraits[] primaryTypeTraits = dataset.getPrimaryTypeTraits(metadataProvider, recordType, metaType);
        ITypeTraits[] typeTraits = new ITypeTraits[primaryTypeTraits.length - 1];
        for (int i = 0; i < typeTraits.length; ++i) {
            typeTraits[i] = primaryTypeTraits[i];
        }
        return typeTraits;
    }

    private static IBinaryComparatorFactory[] getInvListComparatorFactories(MetadataProvider metadataProvider, Dataset dataset, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        return dataset.getPrimaryComparatorFactories(metadataProvider, recordType, metaType);
    }

    private static ITypeTraits[] getTokenTypeTraits(Dataset dataset, Index index, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        int numSecondaryKeys = index.getKeyFieldNames().size();
        DatasetConfig.IndexType indexType = index.getIndexType();
        if (numPrimaryKeys > 1) {
            throw new CompilationException(1015, new Serializable[]{indexType, DatasetUtil.getFullyQualifiedDisplayName(dataset)});
        }
        if (numSecondaryKeys > 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(numSecondaryKeys), indexType, Integer.valueOf(1)});
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ARecordType sourceType = keySourceIndicators == null || keySourceIndicators.get(0) == 0 ? recordType : metaType;
        Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), index.getKeyFieldNames().get(0), sourceType);
        IAType secondaryKeyType = (IAType)keyTypePair.first;
        int numTokenFields = !isPartitioned ? numSecondaryKeys : numSecondaryKeys + 1;
        ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
        tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
        if (isPartitioned) {
            tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
        }
        return tokenTypeTraits;
    }

    private static IBinaryComparatorFactory[] getTokenComparatorFactories(Dataset dataset, Index index, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        int numSecondaryKeys = index.getKeyFieldNames().size();
        DatasetConfig.IndexType indexType = index.getIndexType();
        if (numPrimaryKeys > 1) {
            throw new CompilationException(1015, new Serializable[]{indexType, DatasetUtil.getFullyQualifiedDisplayName(dataset)});
        }
        if (numSecondaryKeys > 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(numSecondaryKeys), indexType, Integer.valueOf(1)});
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ARecordType sourceType = keySourceIndicators == null || keySourceIndicators.get(0) == 0 ? recordType : metaType;
        Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), index.getKeyFieldNames().get(0), sourceType);
        IAType secondaryKeyType = (IAType)keyTypePair.first;
        int numTokenFields = !isPartitioned ? numSecondaryKeys : numSecondaryKeys + 1;
        IBinaryComparatorFactory[] tokenComparatorFactories = new IBinaryComparatorFactory[numTokenFields];
        tokenComparatorFactories[0] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)secondaryKeyType);
        if (isPartitioned) {
            tokenComparatorFactories[1] = ShortBinaryComparatorFactory.INSTANCE;
        }
        return tokenComparatorFactories;
    }

    private static IBinaryTokenizerFactory getTokenizerFactory(Dataset dataset, Index index, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        int numSecondaryKeys = index.getKeyFieldNames().size();
        DatasetConfig.IndexType indexType = index.getIndexType();
        if (numPrimaryKeys > 1) {
            throw new CompilationException(1015, new Serializable[]{indexType, DatasetUtil.getFullyQualifiedDisplayName(dataset)});
        }
        if (numSecondaryKeys > 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(numSecondaryKeys), indexType, Integer.valueOf(1)});
        }
        List<Integer> keySourceIndicators = index.getKeyFieldSourceIndicators();
        ARecordType sourceType = keySourceIndicators == null || keySourceIndicators.get(0) == 0 ? recordType : metaType;
        Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(index.getKeyFieldTypes().get(0), index.getKeyFieldNames().get(0), sourceType);
        IAType secondaryKeyType = (IAType)keyTypePair.first;
        return NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)index.getGramLength());
    }
}

