/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.HttpServerHandler;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class FullResponse
implements IServletResponse {
    private final ChannelHandlerContext ctx;
    private final ByteArrayOutputStream baos;
    private final DefaultFullHttpResponse response;
    private final HttpServerHandler<?> handler;
    private PrintWriter writer;
    private ChannelFuture future;

    public FullResponse(HttpServerHandler<?> handler, ChannelHandlerContext ctx, FullHttpRequest request) {
        this.handler = handler;
        this.ctx = ctx;
        this.baos = new ByteArrayOutputStream(4096);
        this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        HttpUtil.setConnectionHeader((HttpRequest)request, (DefaultHttpResponse)this.response);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        FullHttpResponse fullResponse = this.response.replace(Unpooled.copiedBuffer((byte[])this.baos.toByteArray()));
        fullResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, fullResponse.content().readableBytes());
        ChannelPromise responseCompletionPromise = this.ctx.newPromise();
        responseCompletionPromise.addListener(this.handler);
        this.future = this.ctx.writeAndFlush((Object)fullResponse, responseCompletionPromise);
    }

    @Override
    public IServletResponse setHeader(CharSequence name, Object value) throws IOException {
        this.response.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized PrintWriter writer() {
        if (this.writer == null) {
            Charset charset = io.netty.handler.codec.http.HttpUtil.getCharset((HttpMessage)this.response, (Charset)StandardCharsets.UTF_8);
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, charset));
        }
        return this.writer;
    }

    @Override
    public ChannelFuture lastContentFuture() throws IOException {
        return this.future;
    }

    @Override
    public OutputStream outputStream() {
        return this.baos;
    }

    @Override
    public void setStatus(HttpResponseStatus status) {
        this.response.setStatus(status);
    }

    @Override
    public void notifyChannelWritable() {
    }

    @Override
    public void notifyChannelInactive() {
    }

    @Override
    public void cancel() {
    }
}

