/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.IWindowAggregatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowAggregatorDescriptorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowMaterializingPushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;

abstract class AbstractWindowNestedPlansPushRuntime
extends WindowMaterializingPushRuntime {
    final int nestedAggOutSchemaSize;
    private final WindowAggregatorDescriptorFactory nestedAggFactory;
    private IWindowAggregatorDescriptor nestedAgg;

    AbstractWindowNestedPlansPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, int nestedAggOutSchemaSize, WindowAggregatorDescriptorFactory nestedAggFactory, IHyracksTaskContext ctx, int memSizeInFrames, SourceLocation sourceLoc) {
        super(partitionColumns, partitionComparatorFactories, orderComparatorFactories, projectionColumns, runningAggOutColumns, runningAggFactories, ctx, memSizeInFrames, sourceLoc);
        this.nestedAggFactory = nestedAggFactory;
        this.nestedAggOutSchemaSize = nestedAggOutSchemaSize;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        this.nestedAgg = this.nestedAggCreate();
    }

    @Override
    public void close() throws HyracksDataException {
        super.close();
        this.nestedAgg.close();
    }

    @Override
    protected ArrayTupleBuilder createOutputTupleBuilder(int[] projectionList) {
        return new ArrayTupleBuilder(projectionList.length + this.nestedAggOutSchemaSize);
    }

    final IWindowAggregatorDescriptor nestedAggCreate() throws HyracksDataException {
        return this.nestedAggFactory.createAggregator(this.ctx.getTaskContext(), null, null, null, null, -1L);
    }

    final void nestedAggInit() throws HyracksDataException {
        AbstractWindowNestedPlansPushRuntime.nestedAggInit(this.nestedAgg);
    }

    static void nestedAggInit(IWindowAggregatorDescriptor nestedAgg) throws HyracksDataException {
        nestedAgg.init(null, null, -1, null);
    }

    final void nestedAggAggregate(FrameTupleAccessor tAccess, int tIndex) throws HyracksDataException {
        AbstractWindowNestedPlansPushRuntime.nestedAggAggregate(this.nestedAgg, tAccess, tIndex);
    }

    static void nestedAggAggregate(IWindowAggregatorDescriptor nestedAgg, FrameTupleAccessor tAccess, int tIndex) throws HyracksDataException {
        nestedAgg.aggregate((IFrameTupleAccessor)tAccess, tIndex, null, -1, null);
    }

    final void nestedAggOutputFinalResult(ArrayTupleBuilder outTupleBuilder) throws HyracksDataException {
        AbstractWindowNestedPlansPushRuntime.nestedAggOutputFinalResult(this.nestedAgg, outTupleBuilder);
    }

    static void nestedAggOutputFinalResult(IWindowAggregatorDescriptor nestedAgg, ArrayTupleBuilder outTupleBuilder) throws HyracksDataException {
        nestedAgg.outputFinalResult(outTupleBuilder, null, -1, null);
    }

    final void nestedAggOutputPartialResult(ArrayTupleBuilder outTupleBuilder) throws HyracksDataException {
        AbstractWindowNestedPlansPushRuntime.nestedAggOutputPartialResult(this.nestedAgg, outTupleBuilder);
    }

    static boolean nestedAggOutputPartialResult(IWindowAggregatorDescriptor nestedAgg, ArrayTupleBuilder outTupleBuilder) throws HyracksDataException {
        return nestedAgg.outputPartialResult(outTupleBuilder, null, -1, null);
    }

    final void nestAggDiscardFinalResult() throws HyracksDataException {
        AbstractWindowNestedPlansPushRuntime.nestAggDiscardFinalResult(this.nestedAgg);
    }

    static void nestAggDiscardFinalResult(IWindowAggregatorDescriptor nestedAgg) throws HyracksDataException {
        nestedAgg.discardFinalResult();
    }

    static IScalarEvaluator[] createEvaluators(IScalarEvaluatorFactory[] evalFactories, IEvaluatorContext ctx) throws HyracksDataException {
        IScalarEvaluator[] evals = new IScalarEvaluator[evalFactories.length];
        for (int i = 0; i < evalFactories.length; ++i) {
            evals[i] = evalFactories[i].createScalarEvaluator(ctx);
        }
        return evals;
    }

    static void evaluate(IScalarEvaluator[] evals, IFrameTupleReference inTuple, PointableTupleReference outTuple) throws HyracksDataException {
        for (int i = 0; i < evals.length; ++i) {
            evals[i].evaluate(inTuple, outTuple.getField(i));
        }
    }

    static boolean allTrue(ITupleReference tupleRef, IBinaryBooleanInspector boolAccessor) throws HyracksDataException {
        int n = tupleRef.getFieldCount();
        for (int i = 0; i < n; ++i) {
            boolean v = boolAccessor.getBooleanValue(tupleRef.getFieldData(i), tupleRef.getFieldStart(i), tupleRef.getFieldLength(i));
            if (v) continue;
            return false;
        }
        return true;
    }
}

