/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.netty.resources.ColocatedEventLoopGroup;
import reactor.netty.resources.DefaultLoop;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultLoopKQueue
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopKQueue.class);
    static final boolean kqueue;

    DefaultLoopKQueue() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new KQueueSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new KQueueServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new KQueueDatagramChannel();
        }
        if (channelClass.equals(DomainSocketChannel.class)) {
            return (CHANNEL)new KQueueDomainSocketChannel();
        }
        if (channelClass.equals(ServerDomainSocketChannel.class)) {
            return (CHANNEL)new KQueueServerDomainSocketChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return KQueueSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return KQueueServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return KQueueDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "kqueue";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new KQueueEventLoopGroup(threads, factory);
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof KQueueEventLoopGroup;
    }

    static {
        boolean kqueueCheck = false;
        try {
            Class.forName("io.netty.channel.kqueue.KQueue");
            kqueueCheck = KQueue.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        kqueue = kqueueCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default KQueue support : " + kqueue);
        }
    }
}

