/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.jackson;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.asterix.external.parser.jackson.IObjectPool;
import org.apache.asterix.om.util.container.IObjectFactory;

public abstract class AbstractObjectPool<E, T, Q>
implements IObjectPool<E> {
    private final IObjectFactory<E, T> objectFactory;
    private final Queue<Q> recycledObjects;
    private final T param;

    protected AbstractObjectPool(IObjectFactory<E, T> objectFactory, T param) {
        this.objectFactory = objectFactory;
        this.recycledObjects = new ArrayDeque<Q>();
        this.param = param;
    }

    @Override
    public E getInstance() {
        Object instance = this.unwrap(this.recycledObjects.poll());
        if (this.objectFactory != null && instance == null) {
            instance = this.objectFactory.create(this.param);
        }
        return instance;
    }

    @Override
    public void recycle(E object) {
        if (object != null) {
            this.recycledObjects.add(this.wrap(object));
        }
    }

    protected abstract E unwrap(Q var1);

    protected abstract Q wrap(E var1);

    public String toString() {
        return this.recycledObjects.toString();
    }
}

