/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hyracks.api.dataflow.IPassableTimer;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.OperatorStats;

public class StatsCollector
implements IStatsCollector {
    private static final long serialVersionUID = 6858817639895434578L;
    private final Map<String, IOperatorStats> operatorStatsMap = new LinkedHashMap<String, IOperatorStats>();
    private transient Deque<IPassableTimer> clockHolder = new ArrayDeque<IPassableTimer>();

    public void add(IOperatorStats operatorStats) {
        if (this.operatorStatsMap.containsKey(operatorStats.getName())) {
            throw new IllegalArgumentException("Operator with the same name already exists");
        }
        this.operatorStatsMap.put(operatorStats.getName(), operatorStats);
    }

    public IOperatorStats getOrAddOperatorStats(String operatorName) {
        return this.operatorStatsMap.computeIfAbsent(operatorName, OperatorStats::new);
    }

    public Map<String, IOperatorStats> getAllOperatorStats() {
        return Collections.unmodifiableMap(this.operatorStatsMap);
    }

    public static StatsCollector create(DataInput input) throws IOException {
        StatsCollector statsCollector = new StatsCollector();
        statsCollector.readFields(input);
        return statsCollector;
    }

    public IOperatorStats getAggregatedStats() {
        OperatorStats aggregatedStats = new OperatorStats("aggregated");
        for (IOperatorStats stats : this.operatorStatsMap.values()) {
            aggregatedStats.getTupleCounter().update(stats.getTupleCounter().get());
            aggregatedStats.getTimeCounter().update(stats.getTimeCounter().get());
            aggregatedStats.getDiskIoCounter().update(stats.getDiskIoCounter().get());
        }
        return aggregatedStats;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeInt(this.operatorStatsMap.size());
        for (IOperatorStats operatorStats : this.operatorStatsMap.values()) {
            operatorStats.writeFields(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        int operatorCount = input.readInt();
        for (int i = 0; i < operatorCount; ++i) {
            IOperatorStats opStats = OperatorStats.create((DataInput)input);
            this.operatorStatsMap.put(opStats.getName(), opStats);
        }
    }

    public long takeClock(IPassableTimer newHolder) {
        if (newHolder != null) {
            if (this.clockHolder.peek() != null) {
                this.clockHolder.peek().pause();
            }
            this.clockHolder.push(newHolder);
        }
        return System.nanoTime();
    }

    public void giveClock(IPassableTimer currHolder) {
        this.clockHolder.removeLastOccurrence(currHolder);
        if (this.clockHolder.peek() != null) {
            this.clockHolder.peek().resume();
        }
    }
}

