/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.io.IWritable;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.profiling.counters.MultiResolutionEventProfiler;

public class PartitionProfile
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private PartitionId pid;
    private long openTime;
    private long closeTime;
    private MultiResolutionEventProfiler mrep;

    public static PartitionProfile create(DataInput dis) throws IOException {
        PartitionProfile partitionProfile = new PartitionProfile();
        partitionProfile.readFields(dis);
        return partitionProfile;
    }

    private PartitionProfile() {
    }

    public PartitionProfile(PartitionId pid, long openTime, long closeTime, MultiResolutionEventProfiler mrep) {
        this.pid = pid;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.mrep = mrep;
    }

    public PartitionId getPartitionId() {
        return this.pid;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public MultiResolutionEventProfiler getSamples() {
        return this.mrep;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeLong(this.closeTime);
        output.writeLong(this.openTime);
        this.mrep.writeFields(output);
        this.pid.writeFields(output);
    }

    public void readFields(DataInput input) throws IOException {
        this.closeTime = input.readLong();
        this.openTime = input.readLong();
        this.mrep = MultiResolutionEventProfiler.create(input);
        this.pid = PartitionId.create((DataInput)input);
    }
}

