/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public abstract class AbstractVarLenObjectBuilder {
    protected GrowableArray ary;
    protected DataOutput out;
    protected int startOffset;
    protected int estimateMetaLen;

    public void reset(GrowableArray ary, int estimateLength) throws IOException {
        this.ary = ary;
        this.out = ary.getDataOutput();
        this.startOffset = ary.getLength();
        this.estimateMetaLen = VarLenIntEncoderDecoder.getBytesRequired((int)estimateLength);
        for (int i = 0; i < this.estimateMetaLen; ++i) {
            this.out.writeByte(0);
        }
    }

    public void finish() throws IOException {
        int actualDataLength = this.ary.getLength() - this.startOffset - this.estimateMetaLen;
        int actualMetaLen = VarLenIntEncoderDecoder.getBytesRequired((int)actualDataLength);
        if (actualMetaLen != this.estimateMetaLen) {
            int diff = this.estimateMetaLen - actualMetaLen;
            int actualDataStart = this.startOffset + actualMetaLen;
            if (diff > 0) {
                for (int i = 0; i < actualDataLength; ++i) {
                    this.ary.getByteArray()[actualDataStart + i] = this.ary.getByteArray()[actualDataStart + i + diff];
                }
                this.ary.rewindPositionBy(diff);
            } else {
                int i;
                diff = -diff;
                for (i = 0; i < diff; ++i) {
                    this.out.writeByte(0);
                }
                for (i = this.ary.getLength() - 1; i >= actualDataStart + diff; --i) {
                    this.ary.getByteArray()[i] = this.ary.getByteArray()[i - diff];
                }
            }
        }
        VarLenIntEncoderDecoder.encode((int)actualDataLength, (byte[])this.ary.getByteArray(), (int)this.startOffset);
    }
}

