/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.ResumeOperation;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.ErrorOptions;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.ResponseConstructorsCache;
import com.azure.core.http.rest.SwaggerInterfaceParser;
import com.azure.core.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.serializer.HttpResponseBodyDecoder;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.tracing.TracerProxy;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class RestProxy
implements InvocationHandler {
    private static final ByteBuffer VALIDATION_BUFFER = ByteBuffer.allocate(0);
    private static final String BODY_TOO_LARGE = "Request body emitted %d bytes, more than the expected %d bytes.";
    private static final String BODY_TOO_SMALL = "Request body emitted %d bytes, less than the expected %d bytes.";
    private static final String MUST_IMPLEMENT_PAGE_ERROR = "Unable to create PagedResponse<T>. Body must be of a type that implements: " + Page.class;
    private static final ResponseConstructorsCache RESPONSE_CONSTRUCTORS_CACHE = new ResponseConstructorsCache();
    private final ClientLogger logger = new ClientLogger(RestProxy.class);
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializer;
    private final SwaggerInterfaceParser interfaceParser;
    private final HttpResponseDecoder decoder;

    private RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.interfaceParser = interfaceParser;
        this.decoder = new HttpResponseDecoder(this.serializer);
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    public Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        this.validateResumeOperationIsNotPresent(method);
        try {
            SwaggerMethodParser methodParser = this.getMethodParser(method);
            HttpRequest request = this.createHttpRequest(methodParser, args);
            com.azure.core.util.Context context = methodParser.setContext(args);
            RequestOptions options = methodParser.setRequestOptions(args);
            context = RestProxy.mergeRequestOptionsContext(context, options);
            context = context.addData("caller-method", methodParser.getFullyQualifiedMethodName()).addData("azure-eagerly-read-response", HttpResponseBodyDecoder.shouldEagerlyReadResponse(methodParser.getReturnType()));
            context = this.startTracingSpan(method, context);
            if (options != null) {
                options.getRequestCallback().accept(request);
            }
            if (request.getBody() != null) {
                request.setBody(RestProxy.validateLength(request));
            }
            Mono<HttpResponse> asyncResponse = this.send(request, context);
            Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse = this.decoder.decode(asyncResponse, methodParser);
            return this.handleRestReturnType(asyncDecodedResponse, methodParser, methodParser.getReturnType(), context, options);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }

    void validateResumeOperationIsNotPresent(Method method) {
        if (method.isAnnotationPresent(ResumeOperation.class)) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new Exception("'ResumeOperation' isn't supported.")));
        }
    }

    static com.azure.core.util.Context mergeRequestOptionsContext(com.azure.core.util.Context context, RequestOptions options) {
        if (options == null) {
            return context;
        }
        com.azure.core.util.Context optionsContext = options.getContext();
        if (optionsContext != null && optionsContext != com.azure.core.util.Context.NONE) {
            context = CoreUtils.mergeContexts(context, optionsContext);
        }
        return context;
    }

    static Flux<ByteBuffer> validateLength(HttpRequest request) {
        Flux<ByteBuffer> bbFlux = request.getBody();
        if (bbFlux == null) {
            return Flux.empty();
        }
        long expectedLength = Long.parseLong(request.getHeaders().getValue("Content-Length"));
        return Flux.defer(() -> {
            long[] currentTotalLength = new long[1];
            return Flux.concat((Publisher[])new Publisher[]{bbFlux, Flux.just((Object)VALIDATION_BUFFER)}).handle((buffer, sink) -> {
                if (buffer == null) {
                    return;
                }
                if (buffer == VALIDATION_BUFFER) {
                    if (expectedLength != currentTotalLength[0]) {
                        sink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_SMALL, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    } else {
                        sink.complete();
                    }
                    return;
                }
                currentTotalLength[0] = currentTotalLength[0] + (long)buffer.remaining();
                if (currentTotalLength[0] > expectedLength) {
                    sink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_LARGE, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    return;
                }
                sink.next(buffer);
            });
        });
    }

    private com.azure.core.util.Context startTracingSpan(Method method, com.azure.core.util.Context context) {
        if (!TracerProxy.isTracingEnabled()) {
            return context;
        }
        if (((Boolean)context.getData("disable-tracing").orElse(false)).booleanValue()) {
            return context;
        }
        String spanName = this.interfaceParser.getServiceName() + "." + method.getName();
        context = TracerProxy.setSpanName(spanName, context);
        return TracerProxy.start(spanName, context);
    }

    private HttpRequest createHttpRequest(SwaggerMethodParser methodParser, Object[] args) throws IOException {
        UrlBuilder urlBuilder;
        String path = methodParser.setPath(args);
        UrlBuilder pathUrlBuilder = UrlBuilder.parse(path);
        if (pathUrlBuilder.getScheme() != null) {
            urlBuilder = pathUrlBuilder;
        } else {
            urlBuilder = new UrlBuilder();
            methodParser.setSchemeAndHost(args, urlBuilder);
            if (path != null && !path.isEmpty() && !"/".equals(path)) {
                String hostPath = urlBuilder.getPath();
                if (hostPath == null || hostPath.isEmpty() || "/".equals(hostPath) || path.contains("://")) {
                    urlBuilder.setPath(path);
                } else if (path.startsWith("/")) {
                    urlBuilder.setPath(hostPath + path);
                } else {
                    urlBuilder.setPath(hostPath + "/" + path);
                }
            }
        }
        methodParser.setEncodedQueryParameters(args, urlBuilder);
        URL url = urlBuilder.toUrl();
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.getHttpMethod(), url), methodParser, args);
        HttpHeaders httpHeaders = request.getHeaders();
        methodParser.setHeaders(args, httpHeaders);
        return request;
    }

    private HttpRequest configRequest(HttpRequest request, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        Object bodyContentObject = methodParser.setBody(args);
        if (bodyContentObject == null) {
            request.getHeaders().set("Content-Length", "0");
        } else {
            AccessibleByteArrayOutputStream stream;
            String[] contentTypeParts;
            String contentType = methodParser.getBodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.getHeaders().set("Content-Type", contentType);
            if (bodyContentObject instanceof BinaryData) {
                BinaryData binaryData = (BinaryData)bodyContentObject;
                if (binaryData.getLength() != null) {
                    request.setHeader("Content-Length", binaryData.getLength().toString());
                }
                request.setBody(binaryData.toFluxByteBuffer());
                return request;
            }
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            if (isJson) {
                stream = new AccessibleByteArrayOutputStream();
                this.serializer.serialize(bodyContentObject, SerializerEncoding.JSON, stream);
                request.setHeader("Content-Length", String.valueOf(stream.size()));
                request.setBody((Flux<ByteBuffer>)Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(stream.toByteArray(), 0, stream.size()))));
            } else if (FluxUtil.isFluxByteBuffer(methodParser.getBodyJavaType())) {
                request.setBody((Flux<ByteBuffer>)((Flux)bodyContentObject));
            } else if (bodyContentObject instanceof byte[]) {
                request.setBody((byte[])bodyContentObject);
            } else if (bodyContentObject instanceof String) {
                String bodyContentString = (String)bodyContentObject;
                if (!bodyContentString.isEmpty()) {
                    request.setBody(bodyContentString);
                }
            } else if (bodyContentObject instanceof ByteBuffer) {
                request.setBody((Flux<ByteBuffer>)Flux.just((Object)((ByteBuffer)bodyContentObject)));
            } else {
                stream = new AccessibleByteArrayOutputStream();
                this.serializer.serialize(bodyContentObject, SerializerEncoding.fromHeaders(request.getHeaders()), stream);
                request.setHeader("Content-Length", String.valueOf(stream.size()));
                request.setBody((Flux<ByteBuffer>)Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(stream.toByteArray(), 0, stream.size()))));
            }
        }
        return request;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse, SwaggerMethodParser methodParser, RequestOptions options) {
        return asyncDecodedResponse.flatMap(decodedHttpResponse -> this.ensureExpectedStatus((HttpResponseDecoder.HttpDecodedResponse)decodedHttpResponse, methodParser, options));
    }

    private static Exception instantiateUnexpectedException(UnexpectedExceptionInformation exception, HttpResponse httpResponse, byte[] responseContent, Object responseDecodedContent) {
        Exception result;
        int responseStatusCode = httpResponse.getStatusCode();
        String contentType = httpResponse.getHeaderValue("Content-Type");
        String bodyRepresentation = "application/octet-stream".equalsIgnoreCase(contentType) ? "(" + httpResponse.getHeaderValue("Content-Length") + "-byte body)" : (responseContent == null || responseContent.length == 0 ? "(empty body)" : "\"" + new String(responseContent, StandardCharsets.UTF_8) + "\"");
        try {
            Constructor<? extends HttpResponseException> exceptionConstructor = exception.getExceptionType().getConstructor(String.class, HttpResponse.class, exception.getExceptionBodyType());
            result = exceptionConstructor.newInstance("Status code " + responseStatusCode + ", " + bodyRepresentation, httpResponse, responseDecodedContent);
        }
        catch (ReflectiveOperationException e) {
            String message = "Status code " + responseStatusCode + ", but an instance of " + exception.getExceptionType().getCanonicalName() + " cannot be created. Response body: " + bodyRepresentation;
            result = new IOException(message, e);
        }
        return result;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(HttpResponseDecoder.HttpDecodedResponse decodedResponse, SwaggerMethodParser methodParser, RequestOptions options) {
        int responseStatusCode = decodedResponse.getSourceResponse().getStatusCode();
        if (methodParser.isExpectedResponseStatusCode(responseStatusCode) || options != null && options.getErrorOptions().contains((Object)ErrorOptions.NO_THROW)) {
            return Mono.just((Object)decodedResponse);
        }
        return decodedResponse.getSourceResponse().getBodyAsByteArray().switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), null, null)))).flatMap(responseBytes -> decodedResponse.getDecodedBody((byte[])responseBytes).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), responseBytes, null)))).flatMap(decodedBody -> Mono.error((Throwable)RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), responseBytes, decodedBody))));
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Response.class)) {
            Type bodyType = TypeUtil.getRestResponseBodyType(entityType);
            if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                return response.getSourceResponse().getBody().ignoreElements().then(this.createResponse(response, entityType, null));
            }
            return this.handleBodyReturnType(response, methodParser, bodyType).flatMap(bodyAsObject -> this.createResponse(response, entityType, bodyAsObject)).switchIfEmpty(Mono.defer(() -> this.createResponse(response, entityType, null)));
        }
        return this.handleBodyReturnType(response, methodParser, entityType);
    }

    private Mono<Response<?>> createResponse(HttpResponseDecoder.HttpDecodedResponse response, Type entityType, Object bodyAsObject) {
        Class<Object> cls = TypeUtil.getRawClass(entityType);
        if (cls.equals(Response.class)) {
            cls = ResponseBase.class;
        } else if (cls.equals(PagedResponse.class)) {
            cls = PagedResponseBase.class;
            if (bodyAsObject != null && !TypeUtil.isTypeOrSubTypeOf(bodyAsObject.getClass(), Page.class)) {
                return FluxUtil.monoError(this.logger, new RuntimeException(MUST_IMPLEMENT_PAGE_ERROR));
            }
        }
        Class<Object> clsFinal = cls;
        return Mono.just((Object)RESPONSE_CONSTRUCTORS_CACHE.get(clsFinal)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new RuntimeException("Cannot find suitable constructor for class " + clsFinal)))).flatMap(ctr -> RESPONSE_CONSTRUCTORS_CACHE.invoke((MethodHandle)ctr, response, bodyAsObject));
    }

    private Mono<?> handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Object asyncResult;
        int responseStatusCode = response.getSourceResponse().getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Mono.just((Object)isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Mono<BinaryData> responseBodyBytesAsync = response.getSourceResponse().getBodyAsByteArray();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.mapNotNull(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            asyncResult = FluxUtil.isFluxByteBuffer(entityType) ? Mono.just(response.getSourceResponse().getBody()) : (TypeUtil.isTypeOrSubTypeOf(entityType, BinaryData.class) ? BinaryData.fromFlux(response.getSourceResponse().getBody()) : response.getDecodedBody((byte[])null));
        }
        return asyncResult;
    }

    private Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncHttpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context, RequestOptions options) {
        Object result;
        Mono asyncExpectedResponse = this.ensureExpectedStatus(asyncHttpDecodedResponse, methodParser, options).doOnEach(RestProxy::endTracingSpan).contextWrite((ContextView)Context.of((Object)"TRACING_CONTEXT", (Object)context));
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            Type monoTypeParam = TypeUtil.getTypeArgument(returnType);
            result = TypeUtil.isTypeOrSubTypeOf(monoTypeParam, Void.class) ? asyncExpectedResponse.then() : asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)response, methodParser, monoTypeParam));
        } else if (FluxUtil.isFluxByteBuffer(returnType)) {
            result = asyncExpectedResponse.flatMapMany(ar -> ar.getSourceResponse().getBody());
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            asyncExpectedResponse.block();
            result = null;
        } else {
            result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpResponse, methodParser, returnType)).block();
        }
        return result;
    }

    private static void endTracingSpan(Signal<HttpResponseDecoder.HttpDecodedResponse> signal) {
        if (!TracerProxy.isTracingEnabled()) {
            return;
        }
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        ContextView context = signal.getContextView();
        Optional tracingContext = context.getOrEmpty((Object)"TRACING_CONTEXT");
        boolean disableTracing = Boolean.TRUE.equals(context.getOrDefault((Object)"disable-tracing", (Object)false));
        if (!tracingContext.isPresent() || disableTracing) {
            return;
        }
        int statusCode = 0;
        Throwable throwable = null;
        if (signal.hasValue()) {
            HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse = (HttpResponseDecoder.HttpDecodedResponse)signal.get();
            statusCode = httpDecodedResponse.getSourceResponse().getStatusCode();
        } else if (signal.hasError() && (throwable = signal.getThrowable()) instanceof HttpResponseException) {
            HttpResponseException exception = (HttpResponseException)throwable;
            statusCode = exception.getResponse().getStatusCode();
        }
        TracerProxy.end(statusCode, throwable, (com.azure.core.util.Context)tracingContext.get());
    }

    private static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    private static HttpPipeline createDefaultPipeline() {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy());
        policies.add(new RetryPolicy());
        policies.add(new CookiePolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxy.createDefaultPipeline(), RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter serializer) {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(swaggerInterface, serializer);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

