/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.PythonIPCProto;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.asterix.external.library.PythonLibraryEvaluatorId;
import org.apache.asterix.external.library.msgpack.MessagePackUtils;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.ipc.impl.IPCSystem;

public class PythonLibraryEvaluator
extends AbstractStateObject
implements IDeallocatable {
    public static final String ENTRYPOINT = "entrypoint.py";
    public static final String SITE_PACKAGES = "site-packages";
    private Process p;
    private ILibraryManager libMgr;
    private File pythonHome;
    private PythonIPCProto proto;
    private ExternalFunctionResultRouter router;
    private IPCSystem ipcSys;
    private String sitePkgs;
    private List<String> pythonArgs;
    private Map<String, String> pythonEnv;
    private TaskAttemptId task;
    private IWarningCollector warningCollector;
    private SourceLocation sourceLoc;

    public PythonLibraryEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, ILibraryManager libMgr, File pythonHome, String sitePkgs, List<String> pythonArgs, Map<String, String> pythonEnv, ExternalFunctionResultRouter router, IPCSystem ipcSys, TaskAttemptId task, IWarningCollector warningCollector, SourceLocation sourceLoc) {
        super(jobId, (Object)evaluatorId);
        this.libMgr = libMgr;
        this.pythonHome = pythonHome;
        this.sitePkgs = sitePkgs;
        this.pythonArgs = pythonArgs;
        this.pythonEnv = pythonEnv;
        this.router = router;
        this.task = task;
        this.ipcSys = ipcSys;
        this.warningCollector = warningCollector;
        this.sourceLoc = sourceLoc;
    }

    private void initialize() throws IOException, AsterixException {
        PythonLibraryEvaluatorId fnId = (PythonLibraryEvaluatorId)this.id;
        PythonLibrary library = (PythonLibrary)this.libMgr.getLibrary(fnId.getLibraryDataverseName(), fnId.getLibraryName());
        String wd = library.getFile().getAbsolutePath();
        int port = this.ipcSys.getSocketAddress().getPort();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.pythonHome.getAbsolutePath());
        args.addAll(this.pythonArgs);
        args.add(ENTRYPOINT);
        args.add(InetAddress.getLoopbackAddress().getHostAddress());
        args.add(Integer.toString(port));
        args.add(this.sitePkgs);
        ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
        pb.environment().putAll(this.pythonEnv);
        pb.directory(new File(wd));
        this.p = pb.start();
        this.proto = new PythonIPCProto(this.p.getOutputStream(), this.router, this.p);
        this.proto.start();
        this.proto.helo();
    }

    public long initialize(IExternalFunctionInfo finfo) throws IOException, AsterixException {
        String fn;
        String clazz;
        List externalIdents = finfo.getExternalIdentifier();
        String packageModule = (String)externalIdents.get(0);
        String externalIdent1 = (String)externalIdents.get(1);
        int idx = externalIdent1.lastIndexOf(46);
        if (idx >= 0) {
            clazz = externalIdent1.substring(0, idx);
            fn = externalIdent1.substring(idx + 1);
        } else {
            clazz = null;
            fn = externalIdent1;
        }
        return this.proto.init(packageModule, clazz, fn);
    }

    public ByteBuffer callPython(long id, IAType[] argTypes, IValueReference[] valueReferences, boolean nullCall) throws IOException {
        ByteBuffer ret;
        block2: {
            ret = null;
            try {
                ret = this.proto.call(id, argTypes, valueReferences, nullCall);
            }
            catch (AsterixException e) {
                if (!this.warningCollector.shouldWarn()) break block2;
                this.warningCollector.warn(Warning.of((SourceLocation)this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{e.getMessage()}));
            }
        }
        return ret;
    }

    public ByteBuffer callPythonMulti(long id, ArrayBackedValueStorage arguments, int numTuples) throws IOException {
        ByteBuffer ret;
        block2: {
            ret = null;
            try {
                ret = this.proto.callMulti(id, arguments, numTuples);
            }
            catch (AsterixException e) {
                if (!this.warningCollector.shouldWarn()) break block2;
                this.warningCollector.warn(Warning.of((SourceLocation)this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{e.getMessage()}));
            }
        }
        return ret;
    }

    public void deallocate() {
        if (this.p != null) {
            boolean dead = false;
            try {
                this.p.destroy();
                dead = this.p.waitFor(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!dead) {
                this.p.destroyForcibly();
            }
        }
        this.router.removeRoute(Long.valueOf(this.proto.getRouteId()));
    }

    public static ATypeTag peekArgument(IAType type, IValueReference valueReference) throws HyracksDataException {
        ATypeTag tag = type.getTypeTag();
        if (tag == ATypeTag.ANY) {
            TaggedValuePointable pointy = TaggedValuePointable.FACTORY.createPointable();
            pointy.set(valueReference);
            ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(pointy.getTag());
            IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
            return MessagePackUtils.peekUnknown(rtType);
        }
        return MessagePackUtils.peekUnknown(type);
    }

    public static void setVoidArgument(ArrayBackedValueStorage argHolder) throws IOException {
        argHolder.getDataOutput().writeByte(-36);
        argHolder.getDataOutput().writeShort(0);
    }

    public static PythonLibraryEvaluator getInstance(IExternalFunctionInfo finfo, ILibraryManager libMgr, ExternalFunctionResultRouter router, IPCSystem ipcSys, File pythonHome, IHyracksTaskContext ctx, String sitePkgs, List<String> pythonArgs, Map<String, String> pythonEnv, IWarningCollector warningCollector, SourceLocation sourceLoc) throws IOException, AsterixException {
        PythonLibraryEvaluatorId evaluatorId = new PythonLibraryEvaluatorId(finfo.getLibraryDataverseName(), finfo.getLibraryName(), Thread.currentThread());
        PythonLibraryEvaluator evaluator = (PythonLibraryEvaluator)ctx.getStateObject((Object)evaluatorId);
        if (evaluator == null) {
            evaluator = new PythonLibraryEvaluator(ctx.getJobletContext().getJobId(), evaluatorId, libMgr, pythonHome, sitePkgs, pythonArgs, pythonEnv, router, ipcSys, ctx.getTaskAttemptId(), warningCollector, sourceLoc);
            ctx.getJobletContext().registerDeallocatable((IDeallocatable)evaluator);
            evaluator.initialize();
            ctx.setStateObject((IStateObject)evaluator);
        }
        return evaluator;
    }
}

