/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.Iterator;
import java.util.List;

public final class CategoryClassDistributions {
    private static final List<CategoryClassDistribution> CATEGORY_CLASS_DISTRIBUTIONS = ImmutableList.of((Object)CategoryClassDistribution.buildCategoryClassDistribution("women_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("men_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("children_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("shoe_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("music_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("jewelry_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("home_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("sport_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("book_class.dst"), (Object)CategoryClassDistribution.buildCategoryClassDistribution("electronic_class.dst"));

    public static CategoryClass pickRandomCategoryClass(int categoryId, RandomNumberStream stream) {
        Preconditions.checkArgument((categoryId < CATEGORY_CLASS_DISTRIBUTIONS.size() ? 1 : 0) != 0, (String)"categoryId %s is not less than %s", (Object[])new Object[]{categoryId, CATEGORY_CLASS_DISTRIBUTIONS.size()});
        return CATEGORY_CLASS_DISTRIBUTIONS.get(categoryId).pickRandomCategoryClass(stream);
    }

    private CategoryClassDistributions() {
    }

    public static class CategoryClass {
        private final int id;
        private final String name;
        private final int brandCount;

        public CategoryClass(int id, String name, int brandCount) {
            this.id = id;
            this.name = name;
            this.brandCount = brandCount;
        }

        public int getBrandCount() {
            return this.brandCount;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }

    public static class CategoryClassDistribution {
        private final ImmutableList<String> names;
        private final ImmutableList<Integer> brandCounts;
        private final ImmutableList<Integer> weights;

        public CategoryClassDistribution(ImmutableList<String> names, ImmutableList<Integer> brandCounts, ImmutableList<Integer> weights) {
            this.names = names;
            this.brandCounts = brandCounts;
            this.weights = weights;
        }

        public static CategoryClassDistribution buildCategoryClassDistribution(String filename) {
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder brandCountsBuilder = ImmutableList.builder();
            DistributionUtils.WeightsBuilder weightsBuilder = new DistributionUtils.WeightsBuilder();
            Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(filename);
            while (iterator.hasNext()) {
                List<String> fields = iterator.next();
                Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (Object[])new Object[]{fields.size(), fields});
                List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
                Preconditions.checkState((values.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 values, but it contained %d, %s", (Object[])new Object[]{values.size(), values});
                namesBuilder.add((Object)values.get(0));
                brandCountsBuilder.add((Object)Integer.parseInt(values.get(1)));
                List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
                Preconditions.checkState((weights.size() == 1 ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object[])new Object[]{1, weights.size(), values});
                weightsBuilder.computeAndAddNextWeight(Integer.parseInt(weights.get(0)));
            }
            return new CategoryClassDistribution((ImmutableList<String>)namesBuilder.build(), (ImmutableList<Integer>)brandCountsBuilder.build(), weightsBuilder.build());
        }

        public CategoryClass pickRandomCategoryClass(RandomNumberStream stream) {
            int index = DistributionUtils.pickRandomIndex(this.weights, stream);
            return new CategoryClass(index + 1, (String)this.names.get(index), (Integer)this.brandCounts.get(index));
        }
    }
}

