/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.gcs;

import com.google.cloud.storage.Blob;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.gcs.GCSInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.google.gcs.GCSUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class GCSInputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new GCSInputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths());
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        super.configure(ctx, configuration, warningCollector);
        ExternalDataUtils.validateIncludeExclude(configuration);
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        List<Blob> filesOnly = GCSUtils.listItems(configuration, includeExcludeMatcher, warningCollector);
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private void distributeWorkLoad(List<Blob> items, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (Blob item : items) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(item.getName(), item.getSize());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

