/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.external.api.IJListAccessor;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJObjectAccessor;
import org.apache.asterix.external.api.IJRecordAccessor;
import org.apache.asterix.external.library.JavaTypeInfo;
import org.apache.asterix.external.library.java.JObjectPointableVisitor;
import org.apache.asterix.external.library.java.base.JBoolean;
import org.apache.asterix.external.library.java.base.JByte;
import org.apache.asterix.external.library.java.base.JDate;
import org.apache.asterix.external.library.java.base.JDateTime;
import org.apache.asterix.external.library.java.base.JDouble;
import org.apache.asterix.external.library.java.base.JDuration;
import org.apache.asterix.external.library.java.base.JFloat;
import org.apache.asterix.external.library.java.base.JInt;
import org.apache.asterix.external.library.java.base.JInterval;
import org.apache.asterix.external.library.java.base.JList;
import org.apache.asterix.external.library.java.base.JLong;
import org.apache.asterix.external.library.java.base.JOrderedList;
import org.apache.asterix.external.library.java.base.JRecord;
import org.apache.asterix.external.library.java.base.JShort;
import org.apache.asterix.external.library.java.base.JString;
import org.apache.asterix.external.library.java.base.JTime;
import org.apache.asterix.external.library.java.base.JUnorderedList;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JObjectAccessors {
    private static final Logger LOGGER = LogManager.getLogger();

    private JObjectAccessors() {
    }

    public static IJObjectAccessor createFlatJObjectAccessor(ATypeTag aTypeTag) {
        IJObjectAccessor accessor = null;
        switch (aTypeTag) {
            case BOOLEAN: {
                accessor = new JBooleanAccessor();
                break;
            }
            case TINYINT: {
                accessor = new JInt8Accessor();
                break;
            }
            case SMALLINT: {
                accessor = new JInt16Accessor();
                break;
            }
            case INTEGER: {
                accessor = new JInt32Accessor();
                break;
            }
            case BIGINT: {
                accessor = new JInt64Accessor();
                break;
            }
            case FLOAT: {
                accessor = new JFloatAccessor();
                break;
            }
            case DOUBLE: {
                accessor = new JDoubleAccessor();
                break;
            }
            case STRING: {
                accessor = new JStringAccessor();
                break;
            }
            case DATE: {
                accessor = new JDateAccessor();
                break;
            }
            case DATETIME: {
                accessor = new JDateTimeAccessor();
                break;
            }
            case DURATION: {
                accessor = new JDurationAccessor();
                break;
            }
            case INTERVAL: {
                accessor = new JIntervalAccessor();
                break;
            }
            case TIME: {
                accessor = new JTimeAccessor();
                break;
            }
            case NULL: {
                accessor = new JNullAccessor();
                break;
            }
            case MISSING: {
                accessor = new JMissingAccessor();
                break;
            }
        }
        return accessor;
    }

    public static class JBooleanAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            Boolean v = ABooleanSerializerDeserializer.getBoolean((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ABOOLEAN);
            ((JBoolean)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JInt8Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            byte o = AInt8SerializerDeserializer.getByte((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT8);
            ((JByte)jObject).setValue(o);
            return null;
        }
    }

    public static class JInt16Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            short i = AInt16SerializerDeserializer.getShort((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT16);
            ((JShort)jObject).setValue(i);
            return null;
        }
    }

    public static class JInt32Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int i = AInt32SerializerDeserializer.getInt((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT32);
            ((JInt)jObject).setValue(i);
            return jObject;
        }
    }

    public static class JInt64Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long v = AInt64SerializerDeserializer.getLong((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT64);
            ((JLong)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JFloatAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            float v = AFloatSerializerDeserializer.getFloat((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AFLOAT);
            ((JFloat)jObject).setValue(Float.valueOf(v));
            return jObject;
        }
    }

    public static class JDoubleAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            double v = ADoubleSerializerDeserializer.getDouble((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADOUBLE);
            ((JDouble)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JStringAccessor
    implements IJObjectAccessor {
        private final UTF8StringReader reader = new UTF8StringReader();

        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            String v;
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            try {
                v = this.reader.readUTF((DataInput)new DataInputStream(new ByteArrayInputStream(b, s + 1, l - 1)));
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ASTRING);
            ((JString)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JDateAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int v = ADateSerializerDeserializer.getChronon((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATE);
            ((JDate)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JDateTimeAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long v = ADateTimeSerializerDeserializer.getChronon((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATETIME);
            ((JDateTime)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JDurationAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            ADuration duration = ADurationSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s + 1, l - 1)));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADURATION);
            ((JDuration)jObject).setValue(duration.getMonths(), duration.getMilliseconds());
            return jObject;
        }
    }

    public static class JIntervalAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long intervalStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])b, (int)(s + 1));
            long intervalEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])b, (int)(s + 1));
            byte intervalType = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINTERVAL);
            ((JInterval)jObject).setValue(intervalStart, intervalEnd, intervalType);
            return jObject;
        }
    }

    public static class JTimeAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int v = ATimeSerializerDeserializer.getChronon((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ATIME);
            ((JTime)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JNullAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objPool) throws HyracksDataException {
            return (IJObject)objPool.allocate((Object)BuiltinType.ANULL);
        }
    }

    public static class JMissingAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IPointable pointable, IObjectPool<IJObject, IAType> objPool) throws HyracksDataException {
            return (IJObject)objPool.allocate((Object)BuiltinType.AMISSING);
        }
    }

    public static class JListAccessor
    implements IJListAccessor {
        private final JavaTypeInfo typeInfo;

        public JListAccessor(IObjectPool<IJObject, IAType> objectPool) {
            this.typeInfo = new JavaTypeInfo(objectPool, null, null);
        }

        @Override
        public IJObject access(AListVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool, IAType listType, JObjectPointableVisitor pointableVisitor) throws HyracksDataException {
            List items = pointable.getItems();
            List itemTags = pointable.getItemTags();
            JList list = pointable.ordered() ? new JOrderedList(listType) : new JUnorderedList(listType);
            for (int iter1 = 0; iter1 < items.size(); ++iter1) {
                IJObject listItem;
                IVisitablePointable itemPointable = (IVisitablePointable)items.get(iter1);
                IAType fieldType = ((AbstractCollectionType)listType).getItemType();
                if (fieldType.getTypeTag() == ATypeTag.ANY) {
                    IVisitablePointable itemTagPointable = (IVisitablePointable)itemTags.get(iter1);
                    ATypeTag itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(itemTagPointable.getByteArray()[itemTagPointable.getStartOffset()]);
                    fieldType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)itemTypeTag);
                }
                this.typeInfo.reset(fieldType, fieldType.getTypeTag());
                switch (this.typeInfo.getTypeTag()) {
                    case OBJECT: {
                        listItem = pointableVisitor.visit((ARecordVisitablePointable)itemPointable, this.typeInfo);
                        break;
                    }
                    case ARRAY: 
                    case MULTISET: {
                        listItem = pointableVisitor.visit((AListVisitablePointable)itemPointable, this.typeInfo);
                        break;
                    }
                    case ANY: {
                        throw new RuntimeDataException(ErrorCode.LIBRARY_JOBJECT_ACCESSOR_CANNOT_PARSE_TYPE, new Serializable[]{listType.getTypeTag()});
                    }
                    default: {
                        listItem = pointableVisitor.visit((AFlatValuePointable)itemPointable, this.typeInfo);
                    }
                }
                list.add(listItem);
            }
            return list;
        }
    }

    public static class JRecordAccessor
    implements IJRecordAccessor {
        private final JavaTypeInfo typeInfo;
        private final JRecord jRecord;
        private final IJObject[] jObjects;
        private final LinkedHashMap<String, IJObject> openFields;
        private final UTF8StringReader reader = new UTF8StringReader();

        public JRecordAccessor(ARecordType recordType, IObjectPool<IJObject, IAType> objectPool) {
            this.typeInfo = new JavaTypeInfo(objectPool, null, null);
            this.jObjects = new IJObject[recordType.getFieldNames().length];
            this.openFields = new LinkedHashMap();
            this.jRecord = new JRecord(recordType, this.jObjects, this.openFields);
        }

        @Override
        public JRecord access(ARecordVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool, ARecordType recordType, JObjectPointableVisitor pointableVisitor) throws HyracksDataException {
            this.jRecord.reset();
            ARecordVisitablePointable recordPointable = pointable;
            List fieldPointables = recordPointable.getFieldValues();
            List fieldTypeTags = recordPointable.getFieldTypeTags();
            List fieldNames = recordPointable.getFieldNames();
            int index = 0;
            try {
                IJObject fieldObject = null;
                for (IPointable fieldPointable : fieldPointables) {
                    boolean closedPart = index < recordType.getFieldTypes().length;
                    IPointable tt = (IPointable)fieldTypeTags.get(index);
                    ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(tt.getByteArray()[tt.getStartOffset()]);
                    IAType fieldType = closedPart ? recordType.getFieldTypes()[index] : TypeTagUtil.getBuiltinTypeByTag((ATypeTag)typeTag);
                    IPointable fieldName = (IPointable)fieldNames.get(index);
                    this.typeInfo.reset(fieldType, typeTag);
                    switch (typeTag) {
                        case OBJECT: {
                            fieldObject = pointableVisitor.visit((ARecordVisitablePointable)fieldPointable, this.typeInfo);
                            break;
                        }
                        case ARRAY: 
                        case MULTISET: {
                            if (fieldPointable instanceof AFlatValuePointable) {
                                fieldObject = null;
                                break;
                            }
                            fieldObject = pointableVisitor.visit((AListVisitablePointable)fieldPointable, this.typeInfo);
                            break;
                        }
                        case ANY: {
                            break;
                        }
                        default: {
                            fieldObject = pointableVisitor.visit((AFlatValuePointable)fieldPointable, this.typeInfo);
                        }
                    }
                    if (closedPart) {
                        this.jObjects[index] = fieldObject;
                    } else {
                        byte[] b = fieldName.getByteArray();
                        int s = fieldName.getStartOffset();
                        int l = fieldName.getLength();
                        String v = this.reader.readUTF((DataInput)new DataInputStream(new ByteArrayInputStream(b, s + 1, l - 1)));
                        this.openFields.put(v, fieldObject);
                    }
                    ++index;
                    fieldObject = null;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Failure while accessing a java record", (Throwable)e);
                throw HyracksDataException.create((Throwable)e);
            }
            return this.jRecord;
        }

        public void reset() throws HyracksDataException {
            this.jRecord.reset();
            this.openFields.clear();
        }
    }
}

