/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public abstract class AbstractUnnestMapOperator
extends AbstractUnnestOperator {
    protected final List<Object> variableTypes;
    protected boolean propagateInput;
    protected List<Mutable<ILogicalExpression>> additionalFilteringExpressions;
    protected List<LogicalVariable> minFilterVars;
    protected List<LogicalVariable> maxFilterVars;
    protected boolean propagateIndexFilter;
    protected boolean generateSearchCallBackProceedResultVar;

    public AbstractUnnestMapOperator(List<LogicalVariable> variables, Mutable<ILogicalExpression> expression, List<Object> variableTypes, boolean propagateInput) {
        super(variables, expression);
        this.variableTypes = variableTypes;
        this.propagateInput = propagateInput;
        this.propagateIndexFilter = false;
        this.generateSearchCallBackProceedResultVar = false;
    }

    @Override
    public List<LogicalVariable> getScanVariables() {
        int excludeVarCount = 0;
        if (this.propagateIndexFilter) {
            excludeVarCount += 2;
        }
        if (this.generateSearchCallBackProceedResultVar) {
            ++excludeVarCount;
        }
        return excludeVarCount > 0 ? this.variables.subList(0, this.variables.size() - excludeVarCount) : this.variables;
    }

    public List<Object> getVariableTypes() {
        return this.variableTypes;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                if (AbstractUnnestMapOperator.this.propagateInput) {
                    target.addAllVariables(sources[0]);
                }
                for (LogicalVariable v : AbstractUnnestMapOperator.this.variables) {
                    target.addVariable(v);
                }
            }
        };
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean changed = super.acceptExpressionTransform(visitor);
        if (this.additionalFilteringExpressions != null) {
            for (Mutable<ILogicalExpression> filterExpr : this.additionalFilteringExpressions) {
                changed |= visitor.transform(filterExpr);
            }
        }
        return changed;
    }

    public boolean propagatesInput() {
        return this.propagateInput;
    }

    public void setPropagatesInput(boolean propagateInput) {
        this.propagateInput = propagateInput;
    }

    public List<LogicalVariable> getMinFilterVars() {
        return this.minFilterVars;
    }

    public void setMinFilterVars(List<LogicalVariable> minFilterVars) {
        this.minFilterVars = minFilterVars;
    }

    public List<LogicalVariable> getMaxFilterVars() {
        return this.maxFilterVars;
    }

    public void setMaxFilterVars(List<LogicalVariable> maxFilterVars) {
        this.maxFilterVars = maxFilterVars;
    }

    public void setAdditionalFilteringExpressions(List<Mutable<ILogicalExpression>> additionalFilteringExpressions) {
        this.additionalFilteringExpressions = additionalFilteringExpressions;
    }

    public List<Mutable<ILogicalExpression>> getAdditionalFilteringExpressions() {
        return this.additionalFilteringExpressions;
    }

    public void markPropagageIndexFilter() {
        this.propagateIndexFilter = true;
    }

    public boolean propagateIndexFilter() {
        return this.propagateIndexFilter;
    }

    public LogicalVariable getPropagateIndexMinFilterVar() {
        if (this.propagateIndexFilter) {
            return (LogicalVariable)this.variables.get(this.variables.size() - 2);
        }
        return null;
    }

    public LogicalVariable getPropagateIndexMaxFilterVar() {
        if (this.propagateIndexFilter) {
            return (LogicalVariable)this.variables.get(this.variables.size() - 1);
        }
        return null;
    }

    public void setGenerateCallBackProceedResultVar(boolean generateCallBackProceedResultVar) {
        this.generateSearchCallBackProceedResultVar = generateCallBackProceedResultVar;
    }

    public boolean getGenerateCallBackProceedResultVar() {
        return this.generateSearchCallBackProceedResultVar;
    }
}

