/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.util.JsonUtil;

public class OAuthErrorResponseParser {
    private static final String ERROR = "error";
    private static final String ERROR_DESCRIPTION = "error_description";

    private OAuthErrorResponseParser() {
    }

    public static ErrorResponse fromJson(int code, String json) {
        try {
            return OAuthErrorResponseParser.fromJson(code, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read JSON string: " + json, e);
        }
    }

    public static ErrorResponse fromJson(int code, JsonNode jsonNode) {
        Preconditions.checkArgument((jsonNode != null && jsonNode.isObject() ? 1 : 0) != 0, (String)"Cannot parse error response from non-object value: %s", (Object)jsonNode);
        String error = JsonUtil.getString(ERROR, jsonNode);
        String errorDescription = JsonUtil.getStringOrNull(ERROR_DESCRIPTION, jsonNode);
        return ErrorResponse.builder().responseCode(code).withType(error).withMessage(errorDescription).build();
    }
}

