/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.translator.QueryTranslator;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IActiveEntityController;
import org.apache.asterix.metadata.dataset.DatasetFormatInfo;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.rebalance.IDatasetRebalanceCallback;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RebalanceUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RebalanceUtil() {
    }

    public static boolean rebalance(String database, DataverseName dataverseName, String datasetName, Set<String> targetNcNames, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IDatasetRebalanceCallback datasetRebalanceCallback, boolean forceRebalance) throws Exception {
        Dataset targetDataset;
        Dataset sourceDataset;
        boolean success = true;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            sourceDataset = metadataProvider.findDataset(database, dataverseName, datasetName);
            if (sourceDataset == null) {
                return true;
            }
            HashSet sourceNodes = new HashSet(metadataProvider.findNodes(sourceDataset.getNodeGroupName()));
            if (!forceRebalance && sourceNodes.equals(targetNcNames)) {
                return true;
            }
            if (!targetNcNames.isEmpty()) {
                String nodeGroupName = DatasetUtil.createNodeGroupForNewDataset((String)sourceDataset.getDatabaseName(), (DataverseName)sourceDataset.getDataverseName(), (String)sourceDataset.getDatasetName(), (long)(sourceDataset.getRebalanceCount() + 1L), targetNcNames, (MetadataProvider)metadataProvider);
                targetDataset = sourceDataset.getTargetDatasetForRebalance(nodeGroupName);
                LOGGER.info("Rebalancing {} {} from node group {} with nodes {} to node group {} with nodes {}", (Object)IdentifierUtil.dataset(), (Object)DatasetUtil.getFullyQualifiedDisplayName((Dataset)sourceDataset), (Object)sourceDataset.getNodeGroupName(), sourceNodes, (Object)targetDataset.getNodeGroupName(), targetNcNames);
                if (sourceDataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                    success = RebalanceUtil.rebalance(sourceDataset, targetDataset, metadataProvider, hcc, datasetRebalanceCallback);
                }
            } else {
                targetDataset = null;
                RebalanceUtil.purgeDataset(sourceDataset, metadataProvider, hcc);
            }
            if (success) {
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            } else {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        if (targetNcNames.isEmpty()) {
            return true;
        }
        if (!success) {
            LOGGER.info("Dataset {} rebalance was skipped, see above log for reason", (Object)datasetName);
            return false;
        }
        RebalanceUtil.runWithRetryAfterInterrupt(() -> {
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.rebalanceSwitch(sourceDataset, targetDataset, metadataProvider));
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.dropSourceDataset(sourceDataset, metadataProvider, hcc));
        });
        LOGGER.info("Dataset {} rebalance completed successfully", (Object)datasetName);
        return true;
    }

    private static void runWithRetryAfterInterrupt(Work work) throws Exception {
        int retryCount = 0;
        InterruptedException interruptedException = null;
        boolean done = false;
        do {
            try {
                work.run();
                done = true;
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof InterruptedException) {
                    interruptedException = (InterruptedException)rootCause;
                    Thread.interrupted();
                    LOGGER.log(Level.WARN, "Retry with attempt " + ++retryCount, (Throwable)e);
                    continue;
                }
                throw e;
            }
        } while (!done);
        if (interruptedException != null) {
            throw interruptedException;
        }
    }

    private static void runMetadataTransaction(MetadataProvider metadataProvider, Work work) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        try {
            work.run();
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
    }

    private static boolean rebalance(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc, IDatasetRebalanceCallback datasetRebalanceCallback) throws Exception {
        RebalanceUtil.dropDatasetFiles(target, metadataProvider, hcc);
        if (!datasetRebalanceCallback.canRebalance(metadataProvider, source, target, hcc)) {
            return false;
        }
        RebalanceUtil.createRebalanceTarget(target, metadataProvider, hcc);
        RebalanceUtil.populateDataToRebalanceTarget(source, target, metadataProvider, hcc);
        RebalanceUtil.createAndLoadSecondaryIndexesForTarget(source, target, metadataProvider, hcc);
        datasetRebalanceCallback.afterRebalance(metadataProvider, source, target, hcc);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebalanceSwitch(Dataset source, Dataset target, MetadataProvider metadataProvider) throws AlgebricksException, RemoteException {
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        IMetadataLockManager lockManager = appCtx.getMetadataLockManager();
        LOGGER.debug("attempting to acquire dataset {} upgrade lock", (Object)source.getDatasetName());
        lockManager.upgradeDatasetLockToWrite(metadataProvider.getLocks(), source.getDatabaseName(), source.getDataverseName(), source.getDatasetName());
        LOGGER.debug("acquired dataset {} upgrade lock", (Object)source.getDatasetName());
        LOGGER.info("Updating dataset {} node group from {} to {}", (Object)source.getDatasetName(), (Object)source.getNodeGroupName(), (Object)target.getNodeGroupName());
        try {
            MetadataManager.INSTANCE.updateDataset(mdTxnCtx, target);
            for (IActiveEntityEventsListener listener : activeNotificationHandler.getEventListeners()) {
                if (!(listener instanceof IActiveEntityController)) continue;
                IActiveEntityController controller = (IActiveEntityController)listener;
                controller.replace(target);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            LOGGER.info("dataset {} node group updated to {}", (Object)target.getDatasetName(), (Object)target.getNodeGroupName());
        }
        finally {
            lockManager.downgradeDatasetLockToExclusiveModify(metadataProvider.getLocks(), target.getDatabaseName(), target.getDataverseName(), target.getDatasetName());
        }
    }

    private static void dropSourceDataset(Dataset source, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        RebalanceUtil.dropDatasetFiles(source, metadataProvider, hcc);
        RebalanceUtil.tryDropDatasetNodegroup(source, metadataProvider);
        MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
    }

    private static void tryDropDatasetNodegroup(Dataset source, MetadataProvider metadataProvider) throws Exception {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        String sourceNodeGroup = source.getNodeGroupName();
        appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), sourceNodeGroup);
        MetadataManager.INSTANCE.dropNodegroup(metadataProvider.getMetadataTxnContext(), sourceNodeGroup, true);
    }

    private static void createRebalanceTarget(Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        JobSpecification spec = DatasetUtil.createDatasetJobSpec((Dataset)target, (MetadataProvider)metadataProvider);
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
    }

    private static void populateDataToRebalanceTarget(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        JobSpecification spec = new JobSpecification();
        TxnId txnId = metadataProvider.getTxnIdFactory().create();
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(txnId, true);
        spec.setJobletEventListenerFactory((IJobletEventListenerFactory)jobEventListenerFactory);
        IOperatorDescriptor starter = DatasetUtil.createDummyKeyProviderOp((JobSpecification)spec, (Dataset)source, (MetadataProvider)metadataProvider);
        ITupleProjectorFactory projectorFactory = RebalanceUtil.createTupleProjectorFactory(source, metadataProvider);
        IOperatorDescriptor primaryScanOp = DatasetUtil.createPrimaryIndexScanOp((JobSpecification)spec, (MetadataProvider)metadataProvider, (Dataset)source, (ITupleProjectorFactory)projectorFactory);
        IOperatorDescriptor upsertOp = RebalanceUtil.createPrimaryIndexUpsertOp(spec, metadataProvider, source, target);
        IOperatorDescriptor commitOp = RebalanceUtil.createUpsertCommitOp(spec, metadataProvider, target);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), starter, 0, primaryScanOp, 0);
        int numKeys = target.getPrimaryKeys().size();
        int[] keys = IntStream.range(0, numKeys).toArray();
        int[][] partitionsMap = metadataProvider.getPartitioningProperties(target).getComputeStorageMap();
        MToNPartitioningConnectorDescriptor connectorDescriptor = new MToNPartitioningConnectorDescriptor((IConnectorDescriptorRegistry)spec, (ITuplePartitionComputerFactory)FieldHashPartitionComputerFactory.withMap((int[])keys, (IBinaryHashFunctionFactory[])target.getPrimaryHashFunctionFactories(metadataProvider), (int[][])partitionsMap));
        spec.connect((IConnectorDescriptor)connectorDescriptor, primaryScanOp, 0, upsertOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), upsertOp, 0, commitOp, 0);
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)spec, (boolean)true);
    }

    private static ITupleProjectorFactory createTupleProjectorFactory(Dataset source, MetadataProvider metadataProvider) throws AlgebricksException {
        ARecordType itemType = (ARecordType)metadataProvider.findType(source.getItemTypeDatabaseName(), source.getItemTypeDataverseName(), source.getItemTypeName());
        ARecordType metaType = DatasetUtil.getMetaType((MetadataProvider)metadataProvider, (Dataset)source);
        itemType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)itemType, (IAType)metaType, source);
        int numberOfPrimaryKeys = source.getPrimaryKeys().size();
        return IndexUtil.createPrimaryIndexScanTupleProjectorFactory((DatasetFormatInfo)source.getDatasetFormatInfo(), (ARecordType)ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE, (ARecordType)itemType, (ARecordType)metaType, (int)numberOfPrimaryKeys);
    }

    private static IOperatorDescriptor createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset source, Dataset target) throws AlgebricksException {
        int numKeys = source.getPrimaryKeys().size();
        int numValues = source.hasMetaPart() ? 2 : 1;
        int[] fieldPermutation = IntStream.range(0, numKeys + numValues).toArray();
        Pair upsertOpAndConstraints = DatasetUtil.createPrimaryIndexUpsertOp((JobSpecification)spec, (MetadataProvider)metadataProvider, (Dataset)target, (RecordDescriptor)source.getPrimaryRecordDescriptor(metadataProvider), (int[])fieldPermutation, (IMissingWriterFactory)MissingWriterFactory.INSTANCE);
        IOperatorDescriptor upsertOp = (IOperatorDescriptor)upsertOpAndConstraints.first;
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)upsertOp, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)upsertOpAndConstraints.second));
        return upsertOp;
    }

    private static IOperatorDescriptor createUpsertCommitOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset target) throws AlgebricksException {
        int[] primaryKeyFields = RebalanceUtil.getPrimaryKeyPermutationForUpsert(target);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{target.getCommitRuntimeFactory(metadataProvider, primaryKeyFields, true)}, new RecordDescriptor[]{target.getPrimaryRecordDescriptor(metadataProvider)});
    }

    private static void dropDatasetFiles(Dataset dataset, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL || dataset.getDatasetType() == DatasetConfig.DatasetType.VIEW) {
            return;
        }
        ArrayList<JobSpecification> jobs = new ArrayList<JobSpecification>();
        List indexes = metadataProvider.getDatasetIndexes(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName());
        for (Index index : indexes) {
            jobs.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset, EnumSet.of(IndexDropOperatorDescriptor.DropOption.IF_EXISTS, IndexDropOperatorDescriptor.DropOption.WAIT_ON_IN_USE), null));
        }
        for (JobSpecification jobSpec : jobs) {
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
        }
    }

    private static void createAndLoadSecondaryIndexesForTarget(Dataset source, Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        List indexes = metadataProvider.getDatasetIndexes(source.getDatabaseName(), source.getDataverseName(), source.getDatasetName());
        List secondaryIndexes = indexes.stream().filter(Index::isSecondaryIndex).collect(Collectors.toList());
        List<Index> nonSampleIndexes = secondaryIndexes.stream().filter(idx -> !idx.isSampleIndex()).collect(Collectors.toList());
        List<Index> sampleIndexes = secondaryIndexes.stream().filter(Index::isSampleIndex).collect(Collectors.toList());
        RebalanceUtil.createAndLoadIndexes(target, metadataProvider, hcc, nonSampleIndexes);
        RebalanceUtil.createAndLoadIndexes(target, metadataProvider, hcc, sampleIndexes);
    }

    private static void createAndLoadIndexes(Dataset target, MetadataProvider metadataProvider, IHyracksClientConnection hcc, List<Index> indexes) throws Exception {
        for (Index index : indexes) {
            JobSpecification indexCreationJobSpec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)target, (Index)index, (MetadataProvider)metadataProvider, null);
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)indexCreationJobSpec, (boolean)true);
            JobSpecification indexLoadingJobSpec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)target, (Index)index, (MetadataProvider)metadataProvider, null);
            JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)indexLoadingJobSpec, (boolean)true);
        }
    }

    private static int[] getPrimaryKeyPermutationForUpsert(Dataset dataset) {
        int numFilterFields;
        int f = 2;
        if (dataset.hasMetaPart()) {
            ++f;
        }
        int n = numFilterFields = DatasetUtil.getFilterField((Dataset)dataset) == null ? 0 : 1;
        if (numFilterFields > 0) {
            ++f;
        }
        int numPrimaryKeys = dataset.getPrimaryKeys().size();
        int[] pkIndexes = new int[numPrimaryKeys];
        for (int i = 0; i < pkIndexes.length; ++i) {
            pkIndexes[i] = f++;
        }
        return pkIndexes;
    }

    private static void purgeDataset(Dataset dataset, MetadataProvider metadataProvider, IHyracksClientConnection hcc) throws Exception {
        RebalanceUtil.runWithRetryAfterInterrupt(() -> {
            RebalanceUtil.dropDatasetFiles(dataset, metadataProvider, hcc);
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), true));
            MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
            RebalanceUtil.runMetadataTransaction(metadataProvider, () -> RebalanceUtil.tryDropDatasetNodegroup(dataset, metadataProvider));
            MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
        });
    }

    @FunctionalInterface
    private static interface Work {
        public void run() throws Exception;
    }
}

