/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.speculative;

import com.google.common.annotations.VisibleForTesting;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.client.speculative.SpeculativeRequestExecutionPolicy;
import org.apache.distributedlog.client.speculative.SpeculativeRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpeculativeRequestExecutionPolicy
implements SpeculativeRequestExecutionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSpeculativeRequestExecutionPolicy.class);
    final int firstSpeculativeRequestTimeout;
    final int maxSpeculativeRequestTimeout;
    final float backoffMultiplier;
    int nextSpeculativeRequestTimeout;

    public DefaultSpeculativeRequestExecutionPolicy(int firstSpeculativeRequestTimeout, int maxSpeculativeRequestTimeout, float backoffMultiplier) {
        this.firstSpeculativeRequestTimeout = firstSpeculativeRequestTimeout;
        this.maxSpeculativeRequestTimeout = maxSpeculativeRequestTimeout;
        this.backoffMultiplier = backoffMultiplier;
        this.nextSpeculativeRequestTimeout = firstSpeculativeRequestTimeout;
        if (backoffMultiplier <= 0.0f) {
            throw new IllegalArgumentException("Invalid value provided for backoffMultiplier");
        }
        if (Math.round((double)maxSpeculativeRequestTimeout * (double)backoffMultiplier) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid values for maxSpeculativeRequestTimeout and backoffMultiplier");
        }
    }

    @VisibleForTesting
    int getNextSpeculativeRequestTimeout() {
        return this.nextSpeculativeRequestTimeout;
    }

    @Override
    public void initiateSpeculativeRequest(ScheduledExecutorService scheduler, SpeculativeRequestExecutor requestExecutor) {
        this.issueSpeculativeRequest(scheduler, requestExecutor);
    }

    private void issueSpeculativeRequest(final ScheduledExecutorService scheduler, final SpeculativeRequestExecutor requestExecutor) {
        Future<Boolean> issueNextRequest = requestExecutor.issueSpeculativeRequest();
        issueNextRequest.addEventListener((FutureEventListener)new FutureEventListener<Boolean>(){

            public void onSuccess(Boolean issueNextRequest) {
                if (issueNextRequest.booleanValue()) {
                    DefaultSpeculativeRequestExecutionPolicy.this.scheduleSpeculativeRequest(scheduler, requestExecutor, DefaultSpeculativeRequestExecutionPolicy.this.nextSpeculativeRequestTimeout);
                    DefaultSpeculativeRequestExecutionPolicy.this.nextSpeculativeRequestTimeout = Math.min(DefaultSpeculativeRequestExecutionPolicy.this.maxSpeculativeRequestTimeout, (int)((float)DefaultSpeculativeRequestExecutionPolicy.this.nextSpeculativeRequestTimeout * DefaultSpeculativeRequestExecutionPolicy.this.backoffMultiplier));
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("Stopped issuing speculative requests for {}, speculativeReadTimeout = {}", (Object)requestExecutor, (Object)DefaultSpeculativeRequestExecutionPolicy.this.nextSpeculativeRequestTimeout);
                }
            }

            public void onFailure(Throwable thrown) {
                LOG.warn("Failed to issue speculative request for {}, speculativeReadTimeout = {} : ", new Object[]{requestExecutor, DefaultSpeculativeRequestExecutionPolicy.this.nextSpeculativeRequestTimeout, thrown});
            }
        });
    }

    private void scheduleSpeculativeRequest(final ScheduledExecutorService scheduler, final SpeculativeRequestExecutor requestExecutor, int speculativeRequestTimeout) {
        block2: {
            try {
                scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSpeculativeRequestExecutionPolicy.this.issueSpeculativeRequest(scheduler, requestExecutor);
                    }
                }, (long)speculativeRequestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException re) {
                if (scheduler.isShutdown()) break block2;
                LOG.warn("Failed to schedule speculative request for {}, speculativeReadTimeout = {} : ", new Object[]{requestExecutor, speculativeRequestTimeout, re});
            }
        }
    }
}

