/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

public enum IpVersion {
    IPV4(4),
    IPV6(6),
    UNRECOGNIZED(Integer.MAX_VALUE);

    private final int version;

    private IpVersion(int version) {
        this.version = version;
    }

    public int version() {
        return this.version;
    }

    public static IpVersion fromValue(String value) {
        try {
            int statusCode = Integer.parseInt(value);
            switch (statusCode) {
                case 4: {
                    return IPV4;
                }
                case 6: {
                    return IPV6;
                }
            }
            return IPV4;
        }
        catch (NumberFormatException e) {
            return UNRECOGNIZED;
        }
    }
}

