/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;
import io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceStatusBuilder() {
        this(true);
    }

    public ServiceStatusBuilder(Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this(instance, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getLoadBalancer());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceStatusBuilder that = (ServiceStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

