/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.test.framework.TestSensor;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSensorImpl
extends TargetableTestComponentImpl
implements TestSensor {
    private static final Logger LOG = LoggerFactory.getLogger(TestSensorImpl.class);

    public void start(Collection<? extends Location> locations) {
        final AtomicReference sensor = new AtomicReference();
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            sensor.set(this.getRequiredConfig(SENSOR_NAME));
            final Entity target = this.resolveTarget();
            Duration timeout = (Duration)this.getConfig(TIMEOUT);
            Duration backoffToPeriod = (Duration)this.getConfig(BACKOFF_TO_PERIOD);
            List<Map<String, Object>> assertions = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERTIONS);
            List<Map<String, Object>> abortConditions = TestFrameworkAssertions.getAbortConditions(this, (ConfigKey<Object>)ABORT_CONDITIONS);
            if (!this.getChildren().isEmpty()) {
                throw new RuntimeException(String.format("The entity [%s] cannot have child entities", this.getClass().getName()));
            }
            Supplier<Object> supplier = new Supplier<Object>(){

                public Object get() {
                    Object sensorValue = target.sensors().get(Sensors.newSensor(Object.class, (String)((String)sensor.get())));
                    return sensorValue;
                }
            };
            TestFrameworkAssertions.checkAssertionsEventually(new TestFrameworkAssertions.AssertionOptions((String)sensor.get(), supplier).maxAttempts((Integer)this.getConfig(ITERATION_LIMIT)).timeout(timeout).backoffToPeriod(backoffToPeriod).assertions(assertions).abortConditions(abortConditions));
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            if (sensor.get() != null) {
                LOG.debug("Sensor [{}] test failed for {} (rethrowing)", sensor, (Object)this);
            } else {
                LOG.debug("Sensor test failed for {} (no sensor; rethrowing)", (Object)this);
            }
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void stop() {
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    private Predicate<Object> isEqualTo(final Object value) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != null && Objects.equal((Object)TypeCoercions.coerce((Object)value, input.getClass()), (Object)input);
            }
        };
    }
}

