/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.crypto;

import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.brooklyn.util.crypto.TrustingSslSocketFactory;

public class SslTrustUtils {
    public static final TrustManager TRUST_ALL = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    };
    public static final TrustManager TRUST_NONE = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("No clients allowed.");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("No servers allowed.");
        }
    };
    public static final HostnameVerifier ALL_HOSTS_VALID = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static <T extends URLConnection> T trustAll(T connection) {
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(TrustingSslSocketFactory.getInstance());
            ((HttpsURLConnection)connection).setHostnameVerifier(ALL_HOSTS_VALID);
        }
        return connection;
    }

    public static class DelegatingTrustManager
    implements X509TrustManager {
        private final X509TrustManager delegate;

        public DelegatingTrustManager(X509TrustManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }
}

