/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.handlers;

import java.io.Closeable;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Closeables2;

@Singleton
public class ProfitBricksHttpErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var5_13;
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            switch (response.getStatusCode()) {
                case 400: 
                case 405: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException("This request requires authentication.", (Throwable)httpResponseException);
                    break;
                }
                case 403: {
                    AuthorizationException authorizationException = new AuthorizationException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                case 402: 
                case 409: {
                    IllegalStateException illegalStateException = new IllegalStateException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                case 404: 
                case 410: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                case 413: 
                case 503: {
                    if (response.getMessage().equals("OK")) {
                        HttpResponseException httpResponseException2 = new HttpResponseException("The ProfitBricks team is currently carrying out maintenance.", command, response);
                        break;
                    }
                    InsufficientResourcesException insufficientResourcesException = new InsufficientResourcesException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Closeables2.closeQuietly((Closeable)response.getPayload());
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        Closeables2.closeQuietly((Closeable)response.getPayload());
        command.setException((Exception)var5_13);
    }
}

