/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.objs.BasicSpecParameter;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.guava.Maybe;

public abstract class BrooklynEntityDecorationResolver<DT> {
    public final BrooklynYamlTypeInstantiator.Factory instantiator;

    protected BrooklynEntityDecorationResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
        this.instantiator = instantiator;
    }

    @Deprecated
    public final void decorate(EntitySpec<?> entitySpec, ConfigBag attrs) {
        this.decorate(entitySpec, attrs, (Set<String>)ImmutableSet.of());
    }

    public abstract void decorate(EntitySpec<?> var1, ConfigBag var2, Set<String> var3);

    protected List<? extends DT> buildListOfTheseDecorationsFromEntityAttributes(ConfigBag attrs) {
        Object value = this.getDecorationAttributeJsonValue(attrs);
        if (value == null) {
            return MutableList.of();
        }
        if (value instanceof Iterable) {
            return this.buildListOfTheseDecorationsFromIterable((Iterable)value);
        }
        throw new IllegalArgumentException(this.getDecorationKind() + " body should be iterable, not " + value.getClass());
    }

    protected Map<?, ?> checkIsMap(Object decorationJson) {
        if (!(decorationJson instanceof Map)) {
            throw new IllegalArgumentException(this.getDecorationKind() + " value must be a Map, not " + (decorationJson == null ? null : decorationJson.getClass()));
        }
        return (Map)decorationJson;
    }

    protected List<DT> buildListOfTheseDecorationsFromIterable(Iterable<?> value) {
        MutableList decorations = MutableList.of();
        for (Object decorationJson : value) {
            this.addDecorationFromJsonMap(this.checkIsMap(decorationJson), (List<DT>)decorations);
        }
        return decorations;
    }

    protected abstract String getDecorationKind();

    protected abstract Object getDecorationAttributeJsonValue(ConfigBag var1);

    protected void addDecorationFromJson(Object decorationJson, List<DT> decorations) {
        this.addDecorationFromJsonMap(this.checkIsMap(decorationJson), decorations);
    }

    protected abstract void addDecorationFromJsonMap(Map<?, ?> var1, List<DT> var2);

    public static class TagsResolver
    extends BrooklynEntityDecorationResolver<Iterable<Object>> {
        protected TagsResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
            super(instantiator);
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            String iconUrl;
            Object decorationAttributeJsonValue = this.getDecorationAttributeJsonValue(attrs);
            if (decorationAttributeJsonValue != null) {
                entitySpec.tagsAdd((Iterable)decorationAttributeJsonValue);
            }
            if ((iconUrl = (String)attrs.get(BrooklynConfigKeys.ICON_URL)) != null) {
                entitySpec.tagsAdd((Iterable)MutableList.of((Object)BrooklynTags.newIconUrlTag((String)iconUrl)));
            }
        }

        @Override
        protected String getDecorationKind() {
            return "Brooklyn Tags";
        }

        @Override
        protected Iterable<Object> getDecorationAttributeJsonValue(ConfigBag attrs) {
            Object brooklynTags = attrs.getStringKey("brooklyn.tags");
            if (brooklynTags == null) {
                return null;
            }
            if (!(brooklynTags instanceof List)) {
                throw new IllegalArgumentException("brooklyn.tags should be a List of String elements. You supplied " + brooklynTags);
            }
            Preconditions.checkArgument((boolean)Iterables.all((Iterable)((List)brooklynTags), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return !(input instanceof DeferredSupplier);
                }
            }), (Object)("brooklyn.tags should not contain DeferredSupplier. A DeferredSupplier is made when using $brooklyn:attributeWhenReady. You supplied " + brooklynTags));
            List result = (List)brooklynTags;
            return result;
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<Iterable<Object>> decorations) {
            throw new UnsupportedOperationException("TagsResolver.addDecorationFromJsonMap should never be called.");
        }
    }

    public static class SpecParameterResolver
    extends BrooklynEntityDecorationResolver<SpecParameter<?>> {
        private Function<Object, Object> transformer;

        protected SpecParameterResolver(BrooklynYamlTypeInstantiator.Factory instantiator) {
            super(instantiator);
        }

        @Override
        protected String getDecorationKind() {
            return "Spec Parameter initializer";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            this.transformer = new BrooklynComponentTemplateResolver.SpecialFlagsTransformer(this.instantiator.loader, encounteredRegisteredTypeIds);
            List explicitParams = this.buildListOfTheseDecorationsFromEntityAttributes(attrs);
            BasicSpecParameter.initializeSpecWithExplicitParameters(entitySpec, explicitParams, (BrooklynClassLoadingContext)this.instantiator.loader);
        }

        @Override
        protected List<SpecParameter<?>> buildListOfTheseDecorationsFromIterable(Iterable<?> value) {
            return BasicSpecParameter.parseParameterDefinitionList((List)ImmutableList.copyOf(value), this.transformer, (BrooklynClassLoadingContext)this.instantiator.loader);
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.parameters");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<SpecParameter<?>> decorations) {
            throw new UnsupportedOperationException("SpecParameterResolver.addDecorationFromJsonMap should never be called.");
        }
    }

    public static class InitializerResolver
    extends BrooklynEntityDecorationResolver<EntityInitializer> {
        public InitializerResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Entity initializer";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.addInitializers(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.initializers");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EntityInitializer> decorations) {
            decorations.add(this.instantiator.from(decorationJson).prefix("initializer").newInstance(EntityInitializer.class));
        }
    }

    public static class EnricherSpecResolver
    extends BrooklynEntityDecorationResolver<EnricherSpec<?>> {
        public EnricherSpecResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Enricher";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.enricherSpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.enrichers");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<EnricherSpec<?>> decorations) {
            BrooklynYamlTypeInstantiator.InstantiatorFromKey decoLoader = this.instantiator.from(decorationJson).prefix("enricher");
            Class<Enricher> type = decoLoader.getType(Enricher.class);
            decorations.add((EnricherSpec<?>)((EnricherSpec)EnricherSpec.create(type).configure(decoLoader.getConfigMap())).parameters((Iterable)BasicSpecParameter.fromClass((ManagementContext)this.instantiator.loader.getManagementContext(), type)));
        }
    }

    public static class PolicySpecResolver
    extends BrooklynEntityDecorationResolver<PolicySpec<?>> {
        public PolicySpecResolver(BrooklynYamlTypeInstantiator.Factory loader) {
            super(loader);
        }

        @Override
        protected String getDecorationKind() {
            return "Policy";
        }

        @Override
        public void decorate(EntitySpec<?> entitySpec, ConfigBag attrs, Set<String> encounteredRegisteredTypeIds) {
            entitySpec.policySpecs(this.buildListOfTheseDecorationsFromEntityAttributes(attrs));
        }

        @Override
        protected Object getDecorationAttributeJsonValue(ConfigBag attrs) {
            return attrs.getStringKey("brooklyn.policies");
        }

        @Override
        protected void addDecorationFromJsonMap(Map<?, ?> decorationJson, List<PolicySpec<?>> decorations) {
            PolicySpec spec;
            BrooklynYamlTypeInstantiator.InstantiatorFromKey decoLoader = this.instantiator.from(decorationJson).prefix("policy");
            String policyType = (String)decoLoader.getTypeName().get();
            ManagementContext mgmt = this.instantiator.loader.getManagementContext();
            Maybe item = RegisteredTypes.tryValidate((RegisteredType)mgmt.getTypeRegistry().get(policyType), (RegisteredTypeLoadingContext)RegisteredTypeLoadingContexts.spec(Policy.class));
            if (!item.isNull()) {
                spec = (PolicySpec)mgmt.getTypeRegistry().createSpec((RegisteredType)item.get(), null, PolicySpec.class);
            } else {
                Class<Policy> type = decoLoader.getType(Policy.class);
                spec = (PolicySpec)PolicySpec.create(type).parameters((Iterable)BasicSpecParameter.fromClass((ManagementContext)mgmt, type));
            }
            spec.configure(decoLoader.getConfigMap());
            decorations.add(spec);
        }
    }
}

