/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;

@Beta
public class InterruptingImmediateSupplier<T>
implements ImmediateSupplier<T>,
DeferredSupplier<T> {
    private final Supplier<T> nestedSupplier;

    public InterruptingImmediateSupplier(Supplier<T> nestedSupplier) {
        this.nestedSupplier = nestedSupplier;
    }

    @Override
    public Maybe<T> getImmediately() {
        boolean interrupted = Thread.currentThread().isInterrupted();
        try {
            if (!interrupted) {
                Thread.currentThread().interrupt();
            }
            Maybe maybe = Maybe.ofAllowingNull(this.get());
            return maybe;
        }
        catch (Throwable t) {
            if (Exceptions.getFirstThrowableOfType((Throwable)t, ImmediateSupplier.ImmediateValueNotAvailableException.class) != null) {
                Maybe maybe = Maybe.absent((Throwable)Exceptions.getFirstThrowableOfType((Throwable)t, ImmediateSupplier.ImmediateValueNotAvailableException.class));
                return maybe;
            }
            if (Exceptions.getFirstThrowableOfType((Throwable)t, InterruptedException.class) != null || Exceptions.getFirstThrowableOfType((Throwable)t, RuntimeInterruptedException.class) != null || Exceptions.getFirstThrowableOfType((Throwable)t, CancellationException.class) != null) {
                Maybe maybe = Maybe.absent((Throwable)new ImmediateSupplier.ImmediateValueNotAvailableException("Immediate value not available, required non-blocking execution", t));
                return maybe;
            }
            throw Exceptions.propagate((Throwable)t);
        }
        finally {
            if (!interrupted) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public T get() {
        return (T)this.nestedSupplier.get();
    }

    public static <T> InterruptingImmediateSupplier<T> of(Object o) {
        return (InterruptingImmediateSupplier)InterruptingImmediateSupplier.ofSafe(o).get();
    }

    public static <T> ReferenceWithError<InterruptingImmediateSupplier<T>> ofSafe(final Object o) {
        if (o instanceof Supplier) {
            return ReferenceWithError.newInstanceWithoutError(new InterruptingImmediateSupplier<T>((Supplier)o));
        }
        if (o instanceof Callable) {
            return ReferenceWithError.newInstanceWithoutError(new InterruptingImmediateSupplier<T>(new Supplier<T>(){

                public T get() {
                    try {
                        return ((Callable)o).call();
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            }));
        }
        if (o instanceof Runnable) {
            return ReferenceWithError.newInstanceWithoutError(new InterruptingImmediateSupplier<T>(new Supplier<T>(){

                public T get() {
                    ((Runnable)o).run();
                    return null;
                }
            }));
        }
        return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new InterruptingImmediateSupplierNotSupportedForObject(o));
    }

    public static class InterruptingImmediateSupplierNotSupportedForObject
    extends ImmediateSupplier.ImmediateUnsupportedException {
        private static final long serialVersionUID = 307517409005386500L;

        public InterruptingImmediateSupplierNotSupportedForObject(Object o) {
            super("Type " + o.getClass() + " not supported as InterruptingImmediateSupplier (instance " + o + ")");
        }
    }
}

