/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.primitives.Doubles;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.enricher.stock.PercentageEnricher;
import org.apache.brooklyn.enricher.stock.YamlRollingTimeWindowMeanEnricher;
import org.apache.brooklyn.enricher.stock.YamlTimeWeightedDeltaEnricher;
import org.apache.brooklyn.entity.machine.MachineAttributes;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddMachineMetrics
implements EntityInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(AddMachineMetrics.class);

    public void apply(EntityLocal entity) {
        SshFeed machineMetricsFeed = AddMachineMetrics.createMachineMetricsFeed((Entity)entity);
        ((EntityInternal)entity).feeds().add((Feed)machineMetricsFeed);
        AddMachineMetrics.addMachineMetricsEnrichers((Entity)entity);
        LOG.info("Configured machine metrics feed and enrichers on {}", (Object)entity);
    }

    public static void addMachineMetricsEnrichers(Entity entity) {
        entity.enrichers().add((EnricherSpec)((EnricherSpec)EnricherSpec.create(YamlTimeWeightedDeltaEnricher.class).configure(YamlTimeWeightedDeltaEnricher.SOURCE_SENSOR, MachineAttributes.USED_MEMORY)).configure(YamlTimeWeightedDeltaEnricher.TARGET_SENSOR, MachineAttributes.USED_MEMORY_DELTA_PER_SECOND_LAST));
        entity.enrichers().add((EnricherSpec)((EnricherSpec)EnricherSpec.create(YamlRollingTimeWindowMeanEnricher.class).configure(YamlRollingTimeWindowMeanEnricher.SOURCE_SENSOR, MachineAttributes.USED_MEMORY_DELTA_PER_SECOND_LAST)).configure(YamlRollingTimeWindowMeanEnricher.TARGET_SENSOR, MachineAttributes.USED_MEMORY_DELTA_PER_SECOND_IN_WINDOW));
        entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(PercentageEnricher.class).configure(PercentageEnricher.SOURCE_CURRENT_SENSOR, MachineAttributes.USED_MEMORY)).configure(PercentageEnricher.SOURCE_TOTAL_SENSOR, MachineAttributes.TOTAL_MEMORY)).configure(PercentageEnricher.TARGET_SENSOR, MachineAttributes.USED_MEMORY_PERCENT)).configure(PercentageEnricher.SUPPRESS_DUPLICATES, (Object)true));
    }

    public static SshFeed createMachineMetricsFeed(Entity entity) {
        boolean retrieveUsageMetrics = (Boolean)entity.config().get(SoftwareProcess.RETRIEVE_USAGE_METRICS);
        return (SshFeed)((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().uniqueTag("machineMetricsFeed")).period(Duration.THIRTY_SECONDS)).entity(entity)).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.UPTIME).command("cat /proc/uptime").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Duration>(){

            public Duration apply(SshPollValue input) {
                return Duration.seconds((Number)Double.valueOf(Strings.getFirstWord((String)input.getStdout())));
            }
        })).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.LOAD_AVERAGE).command("uptime").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Double>(){

            public Double apply(SshPollValue input) {
                String loadAverage = Strings.getFirstWordAfter((String)input.getStdout(), (String)"load average:").replace(",", "");
                return Double.valueOf(loadAverage);
            }
        })).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.CPU_USAGE).command("ps -A -o pcpu").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Double>(){

            public Double apply(SshPollValue input) {
                Double cpu = 0.0;
                Iterable stdout = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().split((CharSequence)input.getStdout());
                for (Double each : FluentIterable.from((Iterable)stdout).skip(1).transform((Function)Doubles.stringConverter())) {
                    cpu = cpu + each;
                }
                return cpu / 100.0;
            }
        })).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.USED_MEMORY).command("free | grep Mem:").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(2));
            }
        })).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.FREE_MEMORY).command("free | grep Mem:").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(3));
            }
        })).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)SshPollConfig.forSensor(MachineAttributes.TOTAL_MEMORY).command("free | grep Mem:").enabled(retrieveUsageMetrics)).onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(1));
            }
        })).build();
    }

    static {
        MachineAttributes.init();
    }
}

