/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.LocationSpec;
import org.apache.brooklyn.rest.domain.LocationSummary;

@Path(value="/locations")
@Api(value="Locations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface LocationApi {
    @GET
    @ApiOperation(value="Fetch the list of location definitions (deprecated; locations now included via /catalog/types endpoint)", response=LocationSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @Deprecated
    public List<LocationSummary> list();

    @GET
    @Path(value="/usage/LocatedLocations")
    @ApiOperation(value="Return a summary of all usage", notes="interim API, expected to change")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Map<String, Object>> getLocatedLocations();

    @GET
    @Path(value="/{locationId}")
    @ApiOperation(value="Fetch details about a location instance, or a location definition", response=LocationSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find location"), @ApiResponse(code=500, message="Internal Server Error")})
    public LocationSummary get(@ApiParam(value="Location id to fetch", required=true) @PathParam(value="locationId") String var1, @ApiParam(value="Whether full (inherited) config should be compiled", required=false) @DefaultValue(value="false") @QueryParam(value="full") String var2);

    @POST
    @ApiOperation(value="Create a new location definition (deprecated; locations now installed via /catalog/bundles endpoint)", response=String.class)
    @Deprecated
    @ApiResponses(value={@ApiResponse(code=202, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response create(@ApiParam(name="locationSpec", value="Location specification object", required=true) @Valid LocationSpec var1);

    @DELETE
    @Path(value="/{locationId}")
    @ApiOperation(value="Deletes a location definition by id (deprecated; locations now managed via /catalog/bundles endpoint)")
    @Deprecated
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find location"), @ApiResponse(code=500, message="Internal Server Error")})
    public void delete(@ApiParam(value="Location id to delete", required=true) @PathParam(value="locationId") String var1);
}

