/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Enums;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;

public class EnumTypeCoercions {
    public static <E extends Enum<E>> Function<String, E> stringToEnum(Class<E> type, @Nullable E defaultValue) {
        return new StringToEnumFunction<E>(type, defaultValue);
    }

    public static <T> Function<String, T> stringToEnumUntyped(Class<? super T> type, @Nullable T defaultValue) {
        if (!type.isEnum()) {
            return new Functionals.ConstantFunction(null);
        }
        return new StringToEnumFunction<Enum>(type, (Enum)defaultValue);
    }

    public static Maybe tryCoerceUntyped(String input, Class targetType) {
        if (input == null) {
            return null;
        }
        if (targetType == null) {
            return Maybe.absent("Null enum type");
        }
        if (!targetType.isEnum()) {
            return Maybe.absent("Type '" + targetType + "' is not an enum");
        }
        return EnumTypeCoercions.tryCoerce(input, targetType);
    }

    public static <E extends Enum<E>> Maybe<E> tryCoerce(String input, Class<E> targetType) {
        if (input == null) {
            return null;
        }
        if (targetType == null) {
            return Maybe.absent("Null enum type");
        }
        if (!targetType.isEnum()) {
            return Maybe.absent("Type '" + targetType + "' is not an enum");
        }
        ImmutableList options = ImmutableList.of((Object)input, (Object)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, input), (Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, input));
        for (String value : options) {
            try {
                return Maybe.of(Enum.valueOf(targetType, value));
            }
            catch (IllegalArgumentException iae) {
            }
        }
        Maybe<E> result = Enums.valueOfIgnoreCase(targetType, input);
        if (result.isPresent()) {
            return result;
        }
        return Maybe.absent(new ClassCoercionException("Invalid value '" + input + "' for " + JavaClassNames.simpleClassName(targetType) + "; expected one of " + Arrays.asList(Enums.values(targetType))));
    }

    private static class StringToEnumFunction<E extends Enum<E>>
    implements Function<String, E> {
        private final Class<E> type;
        private final E defaultValue;

        public StringToEnumFunction(Class<E> type, @Nullable E defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public E apply(String input) {
            return (E)((Enum)EnumTypeCoercions.tryCoerce(input, this.type).or(this.defaultValue));
        }
    }
}

