/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.sidecar.common.request.ResponseBytesDecoder;
import org.apache.cassandra.sidecar.common.utils.HttpRange;

public abstract class Request {
    protected final String requestURI;

    protected Request(String requestURI) {
        this.requestURI = requestURI;
    }

    public Map<String, String> headers() {
        HttpRange range = this.range();
        if (range == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HttpHeaderNames.RANGE.toString(), range.toString());
        return Collections.unmodifiableMap(headers);
    }

    protected HttpRange range() {
        return null;
    }

    public abstract HttpMethod method();

    public String requestURI() {
        return this.requestURI;
    }

    public Object requestBody() {
        return null;
    }

    public ResponseBytesDecoder<?> responseBytesDecoder() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{requestURI='" + this.requestURI + '\'' + '}';
    }
}

