/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.exceptions.InsufficientStorageException;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.utils.AsyncFileSystemUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class DiskSpaceProtectionHandler
extends AbstractHandler<Void> {
    private final ServiceConfiguration config;

    @Inject
    protected DiskSpaceProtectionHandler(ServiceConfiguration config, InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
        this.config = config;
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        InstanceMetadata instance = this.metadataFetcher.instance(host);
        String stagingDir = instance.stagingDir();
        if (stagingDir == null) {
            this.logger.warn("Cannot resolve the staging dir. instance={}", (Object)instance.host());
            context.next();
            return;
        }
        float minimumPercentageRequired = this.config.sstableUploadConfiguration().minimumSpacePercentageRequired();
        if (minimumPercentageRequired == 0.0f) {
            this.logger.info("Minimum disk space percentage protection is disabled. It is highly recommend to configure the disk space protection.");
            context.next();
            return;
        }
        double scaledRequiredUsablePercentage = (double)minimumPercentageRequired / 100.0;
        context.vertx().fileSystem().mkdirs(stagingDir).compose(ignored -> AsyncFileSystemUtils.ensureSufficientStorage(stagingDir, scaledRequiredUsablePercentage, this.executorPools.internal())).onSuccess(ignored -> context.next()).onFailure(throwable -> {
            if (throwable instanceof InsufficientStorageException) {
                ((DeltaGauge)instance.metrics().resource().insufficientStagingSpace.metric).update(1L);
                InsufficientStorageException exception = (InsufficientStorageException)throwable;
                throwable = HttpExceptions.wrapHttpException(HttpResponseStatus.INSUFFICIENT_STORAGE, exception.getMessage(), exception);
            }
            this.processFailure((Throwable)throwable, context, host, remoteAddress, request);
        });
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }
}

